/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.status;

import javax.baja.sys.*;

/**
 * BStatusString defines a tuple representing 
 * an String value and status flags.
 *
 * @author    Brian Frank
 * @creation  30 Mar 01
 * @version   $Revision: 24$ $Date: 3/28/05 9:23:06 AM EST$
 * @since     Baja 1.0
 */
public class BStatusString
  extends BStatusValue
{ 

  /*-
  
  class BStatusString
  {
    properties
    {
      value: String
        -- The string value.
        default {[ "" ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.status.BStatusString(47585577)1.0$ @*/
/* Generated Sat Dec 17 22:42:36 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "value"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>value</code> property.
   * The string value.
   * @see javax.baja.status.BStatusString#getValue
   * @see javax.baja.status.BStatusString#setValue
   */
  public static final Property value = newProperty(0, "",null);
  
  /**
   * Get the <code>value</code> property.
   * The string value.
   * @see javax.baja.status.BStatusString#value
   */
  public String getValue() { return getString(value); }
  
  /**
   * Set the <code>value</code> property.
   * The string value.
   * @see javax.baja.status.BStatusString#value
   */
  public void setValue(String v) { setString(value,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BStatusString.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Constructor with value and status.
   */
  public BStatusString(String value, BStatus status) 
  { 
    super(status);
    setValue(value);
  }

  /**
   * Constructor with value.
   */
  public BStatusString(String value) 
  { 
    setValue(value); 
  }

  /**
   * No argument constructor.
   */
  public BStatusString() 
  {
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////  

  /**
   * Get the value as a BValue.
   */
  public final BValue getValueValue()
  {
    return BString.make(getValue());
  }

  /**
   * Get the "value" property.
   */
  public final Property getValueProperty()
  {
    return value;
  }

  /**
   * Return the value property.
   */
  public String valueToString(Context context)
  {
    return getValue();
  }

  /**
   * Get the icon.
   */
  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("statusString.png");

}
