/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security.kerberos;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;


public class BKerberosCredentials
    extends BStruct
    implements BIUserCredentials
{
  /*-
  class BKerberosCredentials
  {
    properties
    {
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.kerberos.BKerberosCredentials(718198358)1.0$ @*/
/* Generated Tue Aug 21 16:30:42 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BKerberosCredentials.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
////////////////////////////////////////////////////////////////
// Contructor
////////////////////////////////////////////////////////////////
  public BKerberosCredentials()
  {
    this.credentials = null;
  }
  
  public BKerberosCredentials(GSSCredential credentials)
  {
    this.credentials = credentials;
  }
  
////////////////////////////////////////////////////////////////
// Accessors
////////////////////////////////////////////////////////////////
  public GSSCredential getCredential()
  {
    return credentials;
  }
  

  public String getUsername()
  {
    if (credentials == null)
      return null;
    
    if (username == null)
    {
      try
      {
        String name = credentials.getName().toString();
        int index = name.indexOf("@");
        if (index > -1)
          name = name.substring(0, index);
        
        username = name;
      }
      catch (GSSException e)
      {
        throw new AuthenticationException("Could not extract username from credentials");
      }
    }
    
    return username;
  }
  
  public String getRealm()
  {
    if (credentials == null)
      return null;
    
    try
    {
      String realm = credentials.getName().toString();
      int index = realm.indexOf("@");
      if (index > -1)
        return realm.substring(index+1);
      else
        return null;
    }
    catch(GSSException e)
    {
      throw new AuthenticationException("Could not extract realm name from credentials");
    }
  }
  
  public boolean isExpired()
  {
    if (credentials == null)
      return false;
    
    try
    {
      return (credentials.getRemainingLifetime() == 0);
    }
    catch (GSSException e)
    {
      throw new AuthenticationException("Could not extract remaining lifetime from credentials");
    }
  }
  
  /**
   * Destroys the sensitive information stored inside the Kerberos ticket.
   */
  public void destroyTicket()
  {
    try
    {
      credentials.dispose();
    }
    catch (GSSException e)
    {
      // Not really anything we can do about this
    }
  }
  
////////////////////////////////////////////////////////////////
// BICredentials interface
////////////////////////////////////////////////////////////////
  /**
   * Decode the credentials from a byte array generated
   * using encode().
   */
  public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException
  {
    BKerberosCredentials x = (BKerberosCredentials)newCopy();
    
    try
    {
      ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
      ObjectInputStream in = new ObjectInputStream(bin);
      x.credentials = (GSSCredential) in.readObject();
    }
    catch (ClassNotFoundException e)
    {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    
    return x;
  }

  @Override
  public byte[] encodeCredentials(Context context) throws IOException
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    ObjectOutputStream out = new ObjectOutputStream(bout);
    out.writeObject(credentials);
    out.flush();
    
    byte[] credBytes = bout.toByteArray();
    
    bout.close();
    
    return credBytes;
  }

  /**
   * Two BKerberosCredentials objects are equivalent if they have the same class, and GSSCredentials.
   */
  @Override
  public boolean equivalent(Object obj)
  {
    return obj != null &&
           obj.getClass() == getClass() &&
      ((BKerberosCredentials)obj).getCredential().equals(getCredential());
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  GSSCredential credentials;
  private String username = null; 

}
