/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security.crypto.se;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.baja.security.crypto.CertManagerFactory;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.baja.nre.security.ClientTlsParameters;

public class BajaSSLSocketFactory
    extends SSLSocketFactory
{
////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////
  public BajaSSLSocketFactory() throws Exception
  {
    factory = (SSLSocketFactory) CertManagerFactory.getInstance().getClientSocketFactory(ClientTlsParameters.DEFAULT);
  }
  
  public static SocketFactory getDefault()
  {
    try
    {
      return new BajaSSLSocketFactory();
    }
    catch(Exception e)
    {
      e.printStackTrace();
      return SSLSocketFactory.getDefault();
    }
  }

////////////////////////////////////////////////////////////////
// createSocket methods
////////////////////////////////////////////////////////////////
  public Socket createSocket(Socket s, String host, int port, boolean autoClose)
    throws IOException
  {
    return factory.createSocket(s, host, port, autoClose);
  }

  public Socket createSocket(String host, int port)
    throws IOException, UnknownHostException
  {
    return factory.createSocket(host, port);
  }

  public Socket createSocket(InetAddress host, int port) throws IOException
  {
    return factory.createSocket(host, port);
  }

  public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) 
    throws IOException, UnknownHostException
  {
    return factory.createSocket(host, port, localAddress, localPort);
  }

  public Socket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort)
    throws IOException
  {
    return factory.createSocket(host, port, localAddress, localPort);
  }

  public synchronized Socket createSocket() throws IOException
  {
    return factory.createSocket();
  }
  
////////////////////////////////////////////////////////////////
// Cipher Suites
////////////////////////////////////////////////////////////////
  public String[] getDefaultCipherSuites()
  {
    return factory.getDefaultCipherSuites();
  }

  public String[] getSupportedCipherSuites()
  {
    return factory.getSupportedCipherSuites();
  }
  
  public int hashCode()
  {
    return factory.hashCode();
  }

  public boolean equals(Object obj)
  {
    return factory.equals(obj);
  }

  public String toString()
  {
    return factory.toString();
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  private SSLSocketFactory factory = null;
}
