/*
 * Copyright 2011 - Tridium Inc, All Rights Reserved.
 */

package javax.baja.security.crypto;

import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import com.tridium.crypto.core.cert.NX509CertificateEntry;

/**
 * ITrustStore is the type of object returned from
 * a call to getSystemTrustStore or getUserTrustStore from an
 * ICryptoManager.
 *
 * @author    $Author$
 * @creation  29 June 2011
 * @version   $Revision$ $Date$
 * @since     Niagara 3.7
 */

public interface ITrustStore
{
  Enumeration<String> aliases() throws Exception;
  boolean containsAlias(String alias) throws Exception;
  void deleteEntry(String alias) throws Exception;
  X509Certificate getCertificate(String alias) throws Exception;
  String getCertificateAlias(X509Certificate cert) throws Exception;
  X509Certificate[] getCertificateChain(String alias) throws Exception;
  Date getCreationDate(String alias) throws Exception;
  boolean isCertificateEntry(String alias) throws Exception;
  boolean isKeyEntry(String alias) throws Exception;
  void setCertificateEntry(String alias, X509Certificate cert) throws Exception;
  int size() throws Exception;
  void save() throws Exception;
  Enumeration<NX509CertificateEntry> getCertificates() throws Exception;
  String findCertificate(X509Certificate match) throws Exception;
  void deleteEntries(String[] aliases) throws Exception;
}
