/*
 * Copyright (c) 2018. Tridium, Inc. All Rights Reserved.
 */

package javax.baja.security.crypto;

import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.nre.security.TlsCipherSuiteGroup;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range = {
  @Range(value = "recommended", ordinal = 0),
  @Range(value = "supported", ordinal = 10)
})
public final class BTlsCipherSuiteGroup
  extends BFrozenEnum
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.crypto.BTlsCipherSuiteGroup(2257881284)1.0$ @*/
/* Generated Mon Jan 29 14:21:30 EST 2018 by Slot-o-Matic (c) Tridium, Inc. 2012 */
  
  /** Ordinal value for recommended. */
  public static final int RECOMMENDED = 0;
  /** Ordinal value for supported. */
  public static final int SUPPORTED = 10;
  
  /** BTlsCipherSuiteGroup constant for recommended. */
  public static final BTlsCipherSuiteGroup recommended = new BTlsCipherSuiteGroup(RECOMMENDED);
  /** BTlsCipherSuiteGroup constant for supported. */
  public static final BTlsCipherSuiteGroup supported = new BTlsCipherSuiteGroup(SUPPORTED);
  
  /** Factory method with ordinal. */
  public static BTlsCipherSuiteGroup make(int ordinal)
  {
    return (BTlsCipherSuiteGroup)recommended.getRange().get(ordinal, false);
  }
  
  /** Factory method with tag. */
  public static BTlsCipherSuiteGroup make(String tag)
  {
    return (BTlsCipherSuiteGroup)recommended.getRange().get(tag);
  }
  
  /** Private constructor. */
  private BTlsCipherSuiteGroup(int ordinal)
  {
    super(ordinal);
  }
  
  public static final BTlsCipherSuiteGroup DEFAULT = recommended;

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BTlsCipherSuiteGroup.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public TlsCipherSuiteGroup getCipherSuiteGroup()
  {
    try
    {
      return TlsCipherSuiteGroup.getEnum(getTag());
    }
    catch(Exception e)
    {
      Logger.getLogger("baja").warning("error generating TlsCipherSuiteGroup from tag '" + getTag() + "', defaulting to recommended");
      return TlsCipherSuiteGroup.recommended;
    }
  }
}
