/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Credentials that specify a username and authentication scheme name
 *
 * @author Patrick Sager on 8/15/2019
 * @since Niagara 4.9
 */
@NiagaraType
@NiagaraProperty(name = "scheme", type = "BString", defaultValue = "")
public class BUsernameSchemeCredentials
  extends BUsernameCredential
  implements BIExtraAttributesCredentials
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.BUsernameSchemeCredentials(3194806672)1.0$ @*/
/* Generated Fri Aug 23 12:21:17 EDT 2019 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "scheme"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code scheme} property.
   * @see #getScheme
   * @see #setScheme
   */
  public static final Property scheme = newProperty(0, "", null);
  
  /**
   * Get the {@code scheme} property.
   * @see #scheme
   */
  public String getScheme() { return getString(scheme); }
  
  /**
   * Set the {@code scheme} property.
   * @see #scheme
   */
  public void setScheme(String v) { setString(scheme, v, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BUsernameSchemeCredentials.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BUsernameSchemeCredentials()
  {

  }

  public BUsernameSchemeCredentials(String username, String scheme)
  {
    super(username);
    setScheme(scheme);
  }

////////////////////////////////////////////////////////////////
// BICredentials
////////////////////////////////////////////////////////////////

  /**
   * Encode the credentials into a byte array which
   * may stored in a credential database.
   */
  @Override
  public byte[] encodeCredentials(Context context)
    throws IOException
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(bout);
    BString.make(getUsername()).encode(out);
    BString.make(getScheme()).encode(out);
    out.flush();
    return bout.toByteArray();
  }

  /**
   * Decode the credentials from a byte array generated
   * using encode().
   */
  @Override
  public BICredentials decodeCredentials(byte[] encoding, Context context)
    throws IOException
  {
    ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
    DataInputStream in = new DataInputStream(bin);
    BUsernameSchemeCredentials x = (BUsernameSchemeCredentials)newCopy();
    x.set(username, (BValue)BString.DEFAULT.decode(in));
    x.set(scheme, (BValue) BString.DEFAULT.decode(in));
    return x;
  }

  /**
   * Two BUsernameAndPassword objects are equivalent if they have the same class, username
   * and password.
   */
  @Override
  public synchronized boolean equivalent(Object obj)
  {
    return obj != null &&
      obj.getClass() == getClass() &&
      Objects.equals(((BUsernameSchemeCredentials)obj).getUsername(), getUsername()) &&
      Objects.equals(((BUsernameSchemeCredentials)obj).getScheme(), getScheme());
  }

  @Override
  public Map<String, Object> getExtraAttributes()
  {
    Map<String, Object> attributes = new HashMap<>();
    attributes.put("scheme", getScheme());
    return attributes;
  }
}
