/**
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * A simple credential containing only a username.
 *
 * @author Melanie Coggan
 * @creation 2014-03-07
 * @since Niagara 4.0
 */
@NiagaraSlots(
  properties = {
    /** The username field. */
    @NiagaraProperty(name = "username", type = "BString", defaultValue = ""),
  }
)
public class BUsernameCredential
  extends BStruct
  implements BIUserCredentials
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.BUsernameCredential(664151787)1.0$ @*/
/* Generated Fri Apr 10 10:49:46 EDT 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "username"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code username} property.
   * The username field.
   * @see #getUsername
   * @see #setUsername
   */
  public static final Property username = newProperty(0, "",null);
  
  /**
   * Get the {@code username} property.
   * The username field.
   * @see #username
   */
  public String getUsername() { return getString(username); }
  
  /**
   * Set the {@code username} property.
   * The username field.
   * @see #username
   */
  public void setUsername(String v) { setString(username,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BUsernameCredential.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////
  public BUsernameCredential()
  {}

  public BUsernameCredential(String username)
  {
    setUsername(username);
  }

////////////////////////////////////////////////////////////////
// BICredentials
////////////////////////////////////////////////////////////////
  @Override
  public byte[] encodeCredentials(Context context) throws IOException
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(bout);
    BString.make(getUsername()).encode(out);
    out.flush();
    return bout.toByteArray();
  }

  @Override
  public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException
  {
    ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
    DataInputStream in = new DataInputStream(bin);
    BUsernameCredential x = (BUsernameCredential)newCopy();
    x.set(username, (BValue)BString.DEFAULT.decode(in));
    return x;
  }

  /**
   * Two BUsernameCredential objects are equivalent if they have the same class, and username.
   */
  @Override
  public synchronized boolean equivalent(Object obj)
  {
    return obj != null &&
      obj.getClass() == getClass() &&
      SecurityUtil.equals(((BUsernameCredential)obj).getUsername(), getUsername());
  }
}
