/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import com.tridium.nre.security.SecretChars;

import java.io.IOException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 *
 *
 * @author Tom Duffy
 * @creation 8/8/2014
 * @since Niagara 4.0
 */
@NiagaraType
@NiagaraSlots(
  properties = {
    @NiagaraProperty(name = "password", type = "BPassword", defaultValue = "BPassword.DEFAULT", flags = Flags.HIDDEN | Flags.READONLY,
      facets = { @Facet(name = "BFacets.FIELD_EDITOR", value = "\"wbutil:UserPasswordFE\""),
                 @Facet(name = "BFacets.UX_FIELD_EDITOR", value = "\"webEditors:UserPasswordEditor\"") })
  }
)
public class BPasswordCache
  extends BAbstractAuthenticator
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.BPasswordCache(1914734084)1.0$ @*/
/* Generated Fri Apr 10 10:49:46 EDT 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "password"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code password} property.
   * @see #getPassword
   * @see #setPassword
   */
  public static final Property password = newProperty(Flags.HIDDEN | Flags.READONLY, BPassword.DEFAULT,BFacets.make(BFacets.make(BFacets.FIELD_EDITOR,"wbutil:UserPasswordFE"),BFacets.make(BFacets.UX_FIELD_EDITOR,"webEditors:UserPasswordEditor")));
  
  /**
   * Get the {@code password} property.
   * @see #password
   */
  public BPassword getPassword() { return (BPassword)get(password); }
  
  /**
   * Set the {@code password} property.
   * @see #password
   */
  public void setPassword(BPassword v) { set(password,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BPasswordCache.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BPasswordCache(){}

  public BPasswordCache(BPassword value)
  {
    setPassword(value);
  }

  public final boolean validate(String authInfo)
  {
    return getPassword().validate(authInfo);
  }

  public final boolean validate(SecretChars authInfo)
  {
    return getPassword().validate(authInfo);
  }

  public BAbstractPasswordEncoder getPasswordEncoder()
  {
    return getPassword().getPasswordEncoder();
  }

  public static final BPasswordCache DEFAULT = new BPasswordCache();
}
