/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import javax.baja.io.BIContextEncodable;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.SecretChars;

@NiagaraType
/**
 * Implementing classes are encodable BObjects that are capable of comparing
 * given Strings, such as passwords, for equality against an encrypted version or one-way hash value.
 *
 * @since Niagara 4.0
 */
public interface BIPasswordValidator
  extends BIContextEncodable
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.BIPasswordValidator(2979906276)1.0$ @*/
/* Generated Wed Apr 15 09:48:42 EDT 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */
  public static final Type TYPE = Sys.loadType(BIPasswordValidator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Return true if the given password matches the validator's.  Because it's not a good security
   * practice to store secret data in Strings, callers should consider using {@link #validate(SecretChars)}
   * instead.
   */
  default boolean validate(String password)
  {
    try(SecretChars secretChars = SecretChars.fromString(password))
    {
      return validate(secretChars);
    }
  }

  /**
   * Return true if the given password matches the validator's.
   */
  boolean validate(SecretChars password);

  /**
   * Return a validator object that uses the same information as the given PBEValidator
   */
  static BIPasswordValidator fromPBEValidator(PBEValidator validator)
  {
    return BPassword.make(validator);
  }
}
