/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import java.io.*;
import javax.baja.sys.*;

/**
 * BICredentials is used for types which store authentication
 * credentials.  See BUsernameAndPassword for a simple implementation.
 *
 * @author    Brian Frank
 * @creation  28 Jan 03
 * @version   $Revision: 5$ $Date: 7/21/10 2:20:49 PM EDT$
 * @since     Baja 1.0
 */
public interface BICredentials
  extends BInterface
{ 

  /**
   * Encode the credentials into a byte array which 
   * may stored in a credential database.
   */
  byte[] encodeCredentials(Context context)
    throws IOException;
  
  /**
   * Decode into a new instance of BICredentials from a 
   * byte array generated using encode().
   */
  BICredentials decodeCredentials(byte[] encoding, Context context)
    throws IOException;

  Type TYPE = Sys.loadType(BICredentials.class);
      
}
