/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BClientCredentials holds another BIUserCredentials in an encoded form.
 * Only certain credentials are allowed to be client credentials. They must be an agent on this
 * class to be eligible.
 *
 * @author Tom Duffy
 * @creation 11/20/2014
 * @since Niagara 4.0
 */
@NiagaraType
@NiagaraProperty(
  name = "clientCredentials",
  type = "BValue",
  defaultValue = "new BUsernameAndPassword(\"\", BPassword.DEFAULT)"
)
public class BClientCredentials
  extends BComponent implements BIDeferOwnership
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.BClientCredentials(1230935077)1.0$ @*/
/* Generated Wed Apr 15 09:48:42 EDT 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "clientCredentials"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code clientCredentials} property.
   * @see #getClientCredentials
   * @see #setClientCredentials
   */
  public static final Property clientCredentials = newProperty(0, new BUsernameAndPassword("", BPassword.DEFAULT),null);
  
  /**
   * Get the {@code clientCredentials} property.
   * @see #clientCredentials
   */
  public BValue getClientCredentials() { return get(clientCredentials); }
  
  /**
   * Set the {@code clientCredentials} property.
   * @see #clientCredentials
   */
  public void setClientCredentials(BValue v) { set(clientCredentials,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BClientCredentials.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Set the credentials on this object.  The typeSpec will also be set to the entered
   * credential's typeSpec.
   *
   * @param credentials new credenials to be saved by this object.
   */
  public void setCredentials(BIUserCredentials credentials)
  {
    AgentList agentList = getAgents().filter(AgentFilter.is(credentials.getType()));
    if(agentList.size() == 0)
    {
      throw new RuntimeException(String.format("%s is not an agent on %s.", credentials.getClass(), getClass()));
    }

    setClientCredentials(((BValue)credentials).newCopy(true));
  }

  /**
   * @return A BIUserCredentials object of the encoded credentials, or a default credential instance
   * if there are none encoded.
   */
  public BIUserCredentials getCredentials()
  {
    return (BIUserCredentials)getClientCredentials();
  }
}
