/*
 * Copyright 2018 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * A SeedInfo file for ClientCert Authentication. Contains Session information
 * along with UsernameCredentials.
 *
 * @author Ashutosh Chaturvedi
 * @creation 11 July 2018
 * @since Niagara 4.7
 */
@NiagaraType(agent = @AgentOn(types = {"baja:ClientCredentials"}))
@NiagaraProperty(name="certificateAlias", type="BString", flags= Flags.READONLY, defaultValue = "BString.DEFAULT")
@NiagaraProperty(name="username", type="BString", flags= Flags.READONLY, defaultValue = "BString.DEFAULT")
public class BCertificateAliasCredential
  extends BStruct
  implements BIPreconnectCredentials, BIAgent
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.BCertificateAliasCredential(3302611174)1.0$ @*/
/* Generated Fri Mar 15 14:09:53 EDT 2019 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "certificateAlias"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code certificateAlias} property.
   * @see #getCertificateAlias
   * @see #setCertificateAlias
   */
  public static final Property certificateAlias = newProperty(Flags.READONLY, BString.DEFAULT, null);
  
  /**
   * Get the {@code certificateAlias} property.
   * @see #certificateAlias
   */
  public String getCertificateAlias() { return getString(certificateAlias); }
  
  /**
   * Set the {@code certificateAlias} property.
   * @see #certificateAlias
   */
  public void setCertificateAlias(String v) { setString(certificateAlias, v, null); }

////////////////////////////////////////////////////////////////
// Property "username"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code username} property.
   * @see #getUsername
   * @see #setUsername
   */
  public static final Property username = newProperty(Flags.READONLY, BString.DEFAULT, null);
  
  /**
   * Get the {@code username} property.
   * @see #username
   */
  public String getUsername() { return getString(username); }
  
  /**
   * Set the {@code username} property.
   * @see #username
   */
  public void setUsername(String v) { setString(username, v, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BCertificateAliasCredential.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Encode the credentials into a byte array which
   * may stored in a credential database.
   *
   * @param context
   */
  @Override
  public byte[] encodeCredentials(Context context) throws IOException
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(bout);
    BString.make(getUsername()).encode(out);
    BString.make(getCertificateAlias()).encode(out);
    out.flush();
    return bout.toByteArray();
  }

  /**
   * Decode into a new instance of BICredentials from a
   * byte array generated using encode().
   *
   * @param encoding
   * @param context
   */
  @Override
  public BICredentials decodeCredentials(byte[] encoding, Context context) throws IOException
  {
    ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
    DataInputStream in = new DataInputStream(bin);
    BCertificateAliasCredential x = new BCertificateAliasCredential();
    x.set(username, (BValue)BString.DEFAULT.decode(in));
    x.set(certificateAlias, (BValue)BString.DEFAULT.decode(in));
    return x;
  }

}
