/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.baja.nre.annotations.NiagaraSlots;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

import com.tridium.session.NiagaraSuperSession;
import com.tridium.session.SessionManager;
import com.tridium.user.BUserPasswordConfiguration;

/**
 * Contains authentication data for users.  AuthenticationSchemes use whatever authenticator is
 * their {@link javax.baja.authn.BAuthenticationScheme#getDefaultAuthenticator()}
 *
 * @author Tom Duffy
 * @creation 8/8/2014
 * @since Niagara 4.0
 */
@NiagaraType
@NiagaraSlots
public abstract class BAbstractAuthenticator
  extends BComponent
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.security.BAbstractAuthenticator(2358527820)1.0$ @*/
/* Generated Fri Apr 10 10:49:46 EDT 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAbstractAuthenticator.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Hook for subclasses, when there is an authenticator specific reason the user should not login.
   *
   * @return  true if the user can login, false otherwise.
   */
  public boolean canLogin()
  {
    return true;
  }

  /**
   * Allows a subclass to pass in a user to determine if the user's password has expired or not.
   * @return true if the user can login, false if the password has expired.
   */
  public boolean canLogin(BUser user)
  {

    if(user.getAuthenticator() instanceof BPasswordAuthenticator)
    {
      BUserPasswordConfiguration userConfig = ((BPasswordAuthenticator)user.getAuthenticator()).getPasswordConfig();
      BAbsTime expiration = userConfig.getExpiration();
      if(!expiration.isNull() && expiration.isBefore(BAbsTime.now()))
      {
        // Password has expired
        return false;
      }
    }
    return true;
  }

  public void changed(Property property, Context context)
  {
    super.changed(property, context);

    BComplex parent = getParent();
    if (parent instanceof BUser && isRunning())
    {
      invalidUserSessions((BUser)parent);
    }
  }

  protected void invalidUserSessions(BUser user)
  {
    Set<String> excludedIds = new HashSet<>();
    NiagaraSuperSession currentSession = SessionManager.getCurrentNiagaraSuperSession();
    if (currentSession != null)
    {
      excludedIds.add(currentSession.getId());
    }
    AccessController.doPrivileged((PrivilegedAction<Void>)() -> {
      SessionManager.invalidateSuperSessions(user, excludedIds);
      return null;
    });
  }

  /*
   * BAbstractAuthenticators cannot have any dynamic properties.
   *
   */
  @Override
  public final boolean isChildLegal(BComponent comp)
  {
    return false;
  }
}
