/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.naming;

/**
 * OrdQuery encapsulates a single query within a BOrd.  
 * A query is composed of a scheme id and an ASCII body.
 *
 * @author    Brian Frank
 * @creation  3 Jan 03
 * @version   $Revision: 9$ $Date: 3/28/05 9:23:01 AM EST$
 * @since     Baja 1.0
 */
public interface OrdQuery
{

  /**
   * Get the scheme id of the query.
   */
  public String getScheme();
  
  /**
   * Get the ASCII body of the query.
   */
  public String getBody();
  
  /**
   * Return if this OrdQuery is an host.  Host queries are
   * absolute and resolve to a BHost.  Since host queries are 
   * absolute they trump any queries to their left during 
   * normalization.
   */
  public boolean isHost();

  /**
   * Return if this OrdQuery is a session.  Sessions queries 
   * are absolute within a host, and resolve to a BISession.
   */
  public boolean isSession();
  
  /**
   * This method is called during BOrd.normalize() to give
   * each query the ability to normalize itself.  The
   * index specifies the location of this query in the 
   * parsed queries list.  This method allows OrdQueries to 
   * merge or truncate relative ords.
   */
  public void normalize(OrdQueryList list, int index);

   /**
   * Return {@code scheme + ":" + body}.
   */  
  public String toString();
  
}

