/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.naming;

import javax.baja.sys.*;

/**
 * BIpScheme is used to identify BIpHosts as "ip:<hostname>".
 *
 * @author    Brian Frank
 * @creation  14 Jan 03
 * @version   $Revision: 3$ $Date: 3/28/05 9:23:00 AM EST$
 * @since     Baja 1.0
 */
public class BIpScheme
  extends BOrdScheme
{

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Private constructor.
   */
  private BIpScheme()
  {
    super("ip");
  }

////////////////////////////////////////////////////////////////
// BOrdScheme
////////////////////////////////////////////////////////////////

  @Override
  public OrdQuery parse(String queryBody)
  {
    return new IpQuery(queryBody);
  }

  @Override
  public OrdTarget resolve(OrdTarget base, OrdQuery query)
    throws SyntaxException, UnresolvedException
  {
    String hostname = query.getBody();
    BHost host = BHost.getHost(hostname);
    if (host == null)
    {
      host = new BIpHost(hostname);
      BHost.mount(host);
    }
    return new OrdTarget(base, host);
  }

////////////////////////////////////////////////////////////////
// IpQuery
////////////////////////////////////////////////////////////////

  static class IpQuery implements OrdQuery
  {
  
    IpQuery(String hostname) { this.hostname = hostname; }
  
    @Override
    public boolean isHost() { return true; }

    @Override
    public boolean isSession() { return false; }
  
    @Override
    public void normalize(OrdQueryList list, int index) { list.trim(index); }

    @Override
    public String getScheme() { return "ip"; }
    
    @Override
    public String getBody() { return hostname; }
    
    public String toString() { return "ip:" + hostname; }
  
    final String hostname;
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////  

  public static final BIpScheme INSTANCE = new BIpScheme();

  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BIpScheme.class);

}

