/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.naming;

import javax.baja.sys.*;
import javax.baja.nav.*;

/**
 * BISession is implemented by BObjects which 
 * represent a session within a host.
 *
 * @author    Brian Frank
 * @creation  1 Apr 03
 * @version   $Revision: 3$ $Date: 2/8/05 2:53:37 PM EST$
 * @since     Baja 1.0
 */
public interface BISession
  extends BINavNode
{

////////////////////////////////////////////////////////////////
// Connection State
////////////////////////////////////////////////////////////////

  /**
   * Does the session have an active logical connection.
   */
  public boolean isConnected();
  
  /**
   * Open a logical connection.
   */
  public void connect()
    throws Exception;

  /**
   * Terminate the connection, but leave the session 
   * mounted in the navigation tree.
   */
  public void disconnect();

  /**
   * Close is defined as a disconnect, plus the session 
   * should be unmounted from the navigation tree.
   */
  public void close();

////////////////////////////////////////////////////////////////
// Naming
////////////////////////////////////////////////////////////////

  /**
   * Get the parent host or null if unmounted.
   */
  public BHost getHost();  

  /**
   * Get the host absolute ord for this object.
   */
  public BOrd getAbsoluteOrd();   

  /**
   * Get the ord of this session within its parent host.
   */
  public BOrd getOrdInHost();   

////////////////////////////////////////////////////////////////
// Context
////////////////////////////////////////////////////////////////
  
  /**
   * Get the Context to use for this session.
   */
  public Context getSessionContext();

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////  

  public static final Type TYPE = Sys.loadType(BISession.class);
  
}

