/*
 * Copyright 2011 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.license;

import javax.baja.sys.*;

/**
 * BILicensed is the interface used to represent object
 * that are licensed using the standard licensing
 * mechanism.
 *
 * @author    Mike Jarmy
 * @creation  11 Oct 11
 * @version   $Revision: 4$ $Date: 3/28/05 9:23:10 AM EST$
 * @since     Baja 1.0
 */
public interface BILicensed 
  extends BInterface
{   
  /**
   * Implement this method to return the Feature, or 
   * return null for no license checks.  Convention is that the
   * vendor and feature name matches the declaring module.
   */
  public Feature getLicenseFeature();
    
  public static final Type TYPE = Sys.loadType(BILicensed.class);
}
