/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.io;

import java.io.*;
import javax.baja.sys.*;

/**
 * BIEncodable is implemented by BObjects which can be
 * serialized and unserialized into both a binary and
 * String format.
 *
 * @author    Brian Frank       
 * @creation  6 Nov 00
 * @version   $Revision: 1$ $Date: 2/27/03 5:12:35 PM EST$
 * @since     Baja 1.0
 */
public interface BIEncodable
  extends BInterface
{ 

  public void encode(DataOutput out)
    throws IOException;

  public BObject decode(DataInput in)
    throws IOException;

  public String encodeToString()
    throws IOException;

  public BObject decodeFromString(String s)
    throws IOException;

  public static final Type TYPE = Sys.loadType(BIEncodable.class);    
  
}
