/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.category;

import javax.baja.sys.*;

/**
 * BICategorizable is implemented by BObjects which can be assigned to
 * one or more categories through the use of a BCategoryMask.
 *
 * @author    Brian Frank
 * @creation  12 Feb 05
 * @version   $Revision: 2$ $Date: 3/28/05 9:22:54 AM EST$
 * @since     Baja 1.0
 */
public interface BICategorizable
  extends BInterface     
{             

  /**
   * Get the category mask to actually use for this object.  This
   * may be different from {@code getCategoryMask()} if using
   * category inheritance.
   */
  BCategoryMask getAppliedCategoryMask();
  
  /**
   * Get the raw category mask for this object.  If the object 
   * supports category inheritance, then this method should return 
   * {@code BCategoryMask.NULL} and return the inherited
   * mask for {@code getAppliedCategoryMask()}.
   */
  BCategoryMask getCategoryMask();

  Type TYPE = Sys.loadType(BICategorizable.class);
    
}
