/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.agent;

import javax.baja.sys.*;
import javax.baja.registry.*;
import javax.baja.security.*;
import javax.baja.util.*;

/**
 * BAbstractPxView is a dynamic view which may be added to BComponents
 * as a property or by overriding getAgents(). 
 *
 * @author    Mike Jarmy
 * @creation  18 Dec 06
 * @version   $Revision: 2$ $Date: 6/11/07 12:41:23 PM EDT$
 * @since     Baja 1.0
 */
public abstract class BAbstractPxView
  extends BStruct
  implements AgentInfo, BIAgent
{
  /*-
  
  class BAbstractPxView
  {
    properties
    {
      icon: BIcon                   
        -- Defines the icon to use for the view
        default {[ BIcon.std("views/view.png") ]}            
      requiredPermissions: BPermissions
        -- Defaults the permissions needed to access the view
        default {[ BPermissions.operatorRead ]}     
      media: BTypeSpec
        -- Specified the target media for the view.
        default {[ BTypeSpec.make("workbench:WbPxMedia") ]}     
        slotfacets {[ BFacets.make(BFacets.TARGET_TYPE, "bajaui:PxMedia") ]}
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.agent.BAbstractPxView(591315902)1.0$ @*/
/* Generated Sat Dec 17 22:42:34 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "icon"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code icon} property.
   * Defines the icon to use for the view
   * @see javax.baja.agent.BAbstractPxView#getIcon
   * @see javax.baja.agent.BAbstractPxView#setIcon
   */
  public static final Property icon = newProperty(0, BIcon.std("views/view.png"),null);
  
  /**
   * Get the {@code icon} property.
   * Defines the icon to use for the view
   * @see javax.baja.agent.BAbstractPxView#icon
   */
  @Override
  public BIcon getIcon() { return (BIcon)get(icon); }
  
  /**
   * Set the {@code icon} property.
   * Defines the icon to use for the view
   * @see javax.baja.agent.BAbstractPxView#icon
   */
  public void setIcon(BIcon v) { set(icon,v,null); }

////////////////////////////////////////////////////////////////
// Property "requiredPermissions"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code requiredPermissions} property.
   * Defaults the permissions needed to access the view
   * @see javax.baja.agent.BAbstractPxView#getRequiredPermissions
   * @see javax.baja.agent.BAbstractPxView#setRequiredPermissions
   */
  public static final Property requiredPermissions = newProperty(0, BPermissions.operatorRead,null);
  
  /**
   * Get the {@code requiredPermissions} property.
   * Defaults the permissions needed to access the view
   * @see javax.baja.agent.BAbstractPxView#requiredPermissions
   */
  @Override
  public BPermissions getRequiredPermissions() { return (BPermissions)get(requiredPermissions); }
  
  /**
   * Set the {@code requiredPermissions} property.
   * Defaults the permissions needed to access the view
   * @see javax.baja.agent.BAbstractPxView#requiredPermissions
   */
  public void setRequiredPermissions(BPermissions v) { set(requiredPermissions,v,null); }

////////////////////////////////////////////////////////////////
// Property "media"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code media} property.
   * Specified the target media for the view.
   * @see javax.baja.agent.BAbstractPxView#getMedia
   * @see javax.baja.agent.BAbstractPxView#setMedia
   */
  public static final Property media = newProperty(0, BTypeSpec.make("workbench:WbPxMedia"),BFacets.make(BFacets.TARGET_TYPE, "bajaui:PxMedia"));
  
  /**
   * Get the {@code media} property.
   * Specified the target media for the view.
   * @see javax.baja.agent.BAbstractPxView#media
   */
  public BTypeSpec getMedia() { return (BTypeSpec)get(media); }
  
  /**
   * Set the {@code media} property.
   * Specified the target media for the view.
   * @see javax.baja.agent.BAbstractPxView#media
   */
  public void setMedia(BTypeSpec v) { set(media,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAbstractPxView.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Constructor with all fields.
   */
  protected BAbstractPxView(BIcon icon, BPermissions permissions, BTypeSpec media)
  {                
    setIcon(icon);      
    setRequiredPermissions(permissions);
    setMedia(media);
  }

  /**
   * No argument constructor.
   */
  protected BAbstractPxView()
  {
  }

////////////////////////////////////////////////////////////////
// AgentInfo
////////////////////////////////////////////////////////////////

  /**
   * Return {@code this}.
   */
  @Override
  public BObject getInstance()
  {
    return this;
  }
  
  /**
   * Return {@code getName()}.
   */
  @Override
  public String getAgentId()
  {
    return getName();
  }
  
  /**
   * Return {@code getType().getTypeInfo()}.
   */
  @Override
  public TypeInfo getAgentType()
  {
    return getType().getTypeInfo();
  }                        
  
  /**
   * Return null.
   */
  @Override
  public String getAppName()
  {
    return null;
  }

  /**
   * Return an empty array.
   */
  @Override
  public TypeInfo[] getAgentOn()
  {
    return emptyTypeInfo;
  }

  /**
   * Return icon property.
   */
  @Override
  public BIcon getIcon(Context cx)
  {
    return getIcon();
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  static TypeInfo[] emptyTypeInfo = new TypeInfo[0];
}

