/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.io;


/**
 * PropertyReference contains information to reference
 * a property to be read.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 14 Mar 02
 * @since Niagara 3 Bacnet 1.0
 */
public interface PropertyReference
{
  /**
   * Get the propertyId.
   *
   * @returns the propertyID.
   */
  int getPropertyId();

  /**
   * Get the property array index.
   *
   * @returns the array index.
   */
  int getPropertyArrayIndex();

  /**
   * Encode the property reference data to Asn.
   *
   * @param AsnOutput the Asn encoder.
   */
  void writeAsn(AsnOutput out);

  /**
   * Decode the property refrerence data from Asn.
   *
   * @param AsnInput the Asn decoder.
   * @throws AsnException if there is an Asn error.
   */
  void readAsn(AsnInput in)
    throws AsnException;
}
 