/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.sys.*;

import javax.baja.bacnet.BacnetConst;

/**
 * BBacnetReinitializedDeviceState represents the state of a device after
 * receiving a ReinitializeDevice-Request.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 23 Jul 2004
 * @since Niagara 3 Bacnet 1.0
 */
public final class BBacnetReinitializedDeviceState
  extends BFrozenEnum
{
  /*-
  enum BBacnetReinitializedDeviceState
  {
    range
    {
      coldStart,
      warmStart,
      startBackup,
      endBackup,
      startRestore,
      endRestore,
      abortRestore
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.enums.BBacnetReinitializedDeviceState(3664174354)1.0$ @*/
/* Generated Wed Aug 04 17:21:44 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

  /**
   * Ordinal value for coldStart.
   */
  public static final int COLD_START = 0;
  /**
   * Ordinal value for warmStart.
   */
  public static final int WARM_START = 1;
  /**
   * Ordinal value for startBackup.
   */
  public static final int START_BACKUP = 2;
  /**
   * Ordinal value for endBackup.
   */
  public static final int END_BACKUP = 3;
  /**
   * Ordinal value for startRestore.
   */
  public static final int START_RESTORE = 4;
  /**
   * Ordinal value for endRestore.
   */
  public static final int END_RESTORE = 5;
  /**
   * Ordinal value for abortRestore.
   */
  public static final int ABORT_RESTORE = 6;

  /**
   * BBacnetReinitializedDeviceState constant for coldStart.
   */
  public static final BBacnetReinitializedDeviceState coldStart = new BBacnetReinitializedDeviceState(COLD_START);
  /**
   * BBacnetReinitializedDeviceState constant for warmStart.
   */
  public static final BBacnetReinitializedDeviceState warmStart = new BBacnetReinitializedDeviceState(WARM_START);
  /**
   * BBacnetReinitializedDeviceState constant for startBackup.
   */
  public static final BBacnetReinitializedDeviceState startBackup = new BBacnetReinitializedDeviceState(START_BACKUP);
  /**
   * BBacnetReinitializedDeviceState constant for endBackup.
   */
  public static final BBacnetReinitializedDeviceState endBackup = new BBacnetReinitializedDeviceState(END_BACKUP);
  /**
   * BBacnetReinitializedDeviceState constant for startRestore.
   */
  public static final BBacnetReinitializedDeviceState startRestore = new BBacnetReinitializedDeviceState(START_RESTORE);
  /**
   * BBacnetReinitializedDeviceState constant for endRestore.
   */
  public static final BBacnetReinitializedDeviceState endRestore = new BBacnetReinitializedDeviceState(END_RESTORE);
  /**
   * BBacnetReinitializedDeviceState constant for abortRestore.
   */
  public static final BBacnetReinitializedDeviceState abortRestore = new BBacnetReinitializedDeviceState(ABORT_RESTORE);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetReinitializedDeviceState.class);

  /**
   * Factory method with ordinal.
   */
  public static BBacnetReinitializedDeviceState make(int ordinal)
  {
    return (BBacnetReinitializedDeviceState)coldStart.getRange().get(ordinal, false);
  }

  /**
   * Factory method with tag.
   */
  public static BBacnetReinitializedDeviceState make(String tag)
  {
    return (BBacnetReinitializedDeviceState)coldStart.getRange().get(tag);
  }

  /**
   * Private constructor.
   */
  private BBacnetReinitializedDeviceState(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Static methods
////////////////////////////////////////////////////////////////

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    return DEFAULT.getRange().getTag(id);
  }

  /**
   * @return String representation of this BEnum.
   */
  public String toString(Context context)
  {
    if ((context != null) && context.equals(BacnetConst.facetsContext))
      return getTag();
    return getDisplayTag(context);
  }


////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  public static final BBacnetReinitializedDeviceState DEFAULT = coldStart;
}
