/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.sys.*;

import javax.baja.alarm.ext.BNotifyType;

import javax.baja.bacnet.BacnetConst;

/**
 * BBacnetNotifyType represents the Bacnet Notify Type
 * enumeration.
 *
 * @author Craig Gemmill
 * @version $Revision: 5$ $Date: 11/28/01 6:14:21 AM$
 * @creation 07 Aug 01
 * @since Niagara 3 Bacnet 1.0
 */
public final class BBacnetNotifyType
  extends BFrozenEnum
{
  /*-
  enum BBacnetNotifyType
  {
    range
    {
      alarm,
      event,
      ackNotification
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.enums.BBacnetNotifyType(2488986714)1.0$ @*/
/* Generated Thu Apr 01 15:19:44 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

  /**
   * Ordinal value for alarm.
   */
  public static final int ALARM = 0;
  /**
   * Ordinal value for event.
   */
  public static final int EVENT = 1;
  /**
   * Ordinal value for ackNotification.
   */
  public static final int ACK_NOTIFICATION = 2;

  /**
   * BBacnetNotifyType constant for alarm.
   */
  public static final BBacnetNotifyType alarm = new BBacnetNotifyType(ALARM);
  /**
   * BBacnetNotifyType constant for event.
   */
  public static final BBacnetNotifyType event = new BBacnetNotifyType(EVENT);
  /**
   * BBacnetNotifyType constant for ackNotification.
   */
  public static final BBacnetNotifyType ackNotification = new BBacnetNotifyType(ACK_NOTIFICATION);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetNotifyType.class);

  /**
   * Factory method with ordinal.
   */
  public static BBacnetNotifyType make(int ordinal)
  {
    return (BBacnetNotifyType)alarm.getRange().get(ordinal);
  }

  /**
   * Factory method with tag.
   */
  public static BBacnetNotifyType make(String tag)
  {
    return (BBacnetNotifyType)alarm.getRange().get(tag);
  }

  /**
   * Private constructor.
   */
  private BBacnetNotifyType(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Static methods
////////////////////////////////////////////////////////////////

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    return DEFAULT.getRange().getTag(id);
  }

  /**
   * Generate the correct ordinal mapping from BNotifyType
   * to BBacnetNotifyType.
   * <p>
   * BNotifyType.alert is mapped to BBacnetNotifyType.event.
   *
   * @param notifyType the BNotifyType.
   * @return the ordinal representing the corresponding BBacnetNotifyType.
   */
  public static BBacnetNotifyType make(BNotifyType notifyType)
  {
    return new BBacnetNotifyType(notifyType.getOrdinal());
  }

  /**
   * Generate the correct ordinal mapping from BNotifyType
   * to BBacnetNotifyType.
   * <p>
   * BNotifyType.alert is mapped to BBacnetNotifyType.event.
   *
   * @param notifyType the BNotifyType.
   * @return the ordinal representing the corresponding BBacnetNotifyType.
   */
  public static int fromBNotifyType(BNotifyType notifyType)
  {
    return notifyType.getOrdinal();
  }

  /**
   * @return String representation of this BEnum.
   */
  public String toString(Context context)
  {
    if ((context != null) && context.equals(BacnetConst.facetsContext))
      return getTag();
    return getDisplayTag(context);
  }


////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  public static final BBacnetNotifyType DEFAULT = alarm;
}