/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.sys.*;

import javax.baja.bacnet.BacnetConst;

/**
 * BBacnetErrorCode represents the error-code portion of the
 * BACnet Error sequence.
 * <p>
 * BBacnetErrorCode is an "extensible" enumeration.
 * Values 0-255 are reserved for use by ASHRAE.
 * Values from 256-65535 (0xFFFF)
 * can be used for proprietary extensions.
 * <p>
 * Note that for proprietary extensions, a given ordinal is not
 * globally mapped to the same enumeration.  Type X from vendor
 * A will be different than type X from vendor B.  Extensions are
 * also not guaranteed unique within a vendor's own products, so
 * type Y in device A from vendor A will in general be different
 * than type Y in device B from vendor A.
 *
 * @author Craig Gemmill
 * @version $Revision: 7$ $Date: 12/19/01 4:35:58 PM$
 * @creation 10 Aug 00
 * @since Niagara 3 Bacnet 1.0
 */

public final class BBacnetErrorCode
  extends BFrozenEnum
  implements BacnetConst
{
  /*-
  enum BBacnetErrorCode
  {
    range
    {
      other,
      authenticationFailed,
      configurationInProgress,
      deviceBusy,
      dynamicCreationNotSupported,
      fileAccessDenied,
      incompatibleSecurityLevels,
      inconsistentParameters,
      inconsistentSelectionCriterion,
      invalidDataType,
      invalidFileAccessMethod,
      invalidFileStartPosition,
      invalidOperatorName,
      invalidParameterDataType,
      invalidTimeStamp,
      keyGenerationError,
      missingRequiredParameter,
      noObjectsOfSpecifiedType,
      noSpaceForObject,
      noSpaceToAddListElement,
      noSpaceToWriteProperty,
      noVtSessionsAvailable,
      propertyIsNotA_List,
      objectDeletionNotPermitted,
      objectIdentifierAlreadyExists,
      operationalProblem,
      passwordFailure,
      readAccessDenied,
      securityNotSupported,
      serviceRequestDenied,
      timeout,
      unknownObject,
      unknownProperty,
      removed,
      unknownVtClass,
      unknownVtSession,
      unsupportedObjectType,
      valueOutOfRange,
      vtSessionAlreadyClosed,
      vtSessionTerminationFailure,
      writeAccessDenied,
      characterSetNotSupported,
      invalidArrayIndex,
      covSubscriptionFailed,
      notCovProperty,
      optionalFunctionalityNotSupported,
      invalidConfigurationData,
      datatypeNotSupported,
      duplicateName,
      duplicateObjectId,
      propertyIsNotAnArray,
      abortBufferOverflow,
      abortInvalidApduInThisState,
      abortPreemptedByHigherPriorityTask,
      abortSegmentationNotSupported,
      abortProprietary,
      abortOther,
      invalidTag,
      networkDown,
      rejectBufferOverflow,
      rejectInconsistentParameters,
      rejectInvalidParameterDataType,
      rejectInvalidTag,
      rejectMissingRequiredParameter,
      rejectParameterOutOfRange,
      rejectTooManyArguments,
      rejectUndefinedEnumeration,
      rejectUnrecognizedService,
      rejectProprietary,
      rejectOther,
      unknownDevice,
      unknownRoute,
      valueNotInitialized,
      invalidEventState,
      noAlarmConfigured,
      logBufferFull,
      loggedValuePurged,
      noPropertySpecified,
      notConfiguredForTriggeredLogging,
      unknownSubscription,
      parameterOutOfRange,
      listElementNotFound,
      busy,
      communicationDisabled,
      success,
      accessDenied,
      badDestinationAddress,
      badDestinationDeviceId,
      badSignature,
      badSourceAddress,
      badTimestamp,
      cannotUseKey,
      cannotVerifyMessageId,
      correctKeyRevision,
      destinationDeviceIdRequired,
      duplicateMessage,
      encryptionNotConfigured,
      encryptionRequired,
      incorrectKey,
      invalidKeyData,
      keyUpdateInProgress,
      malformedMessage,
      notKeyServer,
      securityNotConfigured,
      sourceSecurityRequired,
      tooManyKeys,
      unknownAuthenticationType,
      unknownKey,
      unknownKeyRevision,
      unknownSourceMessage,
      notRouterToDnet,
      routerBusy,
      unknownNetworkMessage,
      messageTooLong,
      securityError,
      addressingError,
      writeBdtFailed,
      readBdtFailed,
      registerForeignDeviceFailed,
      readFdtFailed,
      deleteFdtEntryFailed,
      distributeBroadcastFailed,
      unknownFileSize,
      abortApduTooLong,
      abortApplicationExceededReplyTime,
      abortOutOfResources,
      abortTsmTimeout,
      abortWindowSizeOutOfRange,
      fileFull,
      inconsistentConfiguration,
      inconsistentObjectType,
      internalError,
      notConfigured,
      outOfMemory,
      valueTooLong,
      abortInsufficientSecurity,
      abortSecurityError
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.enums.BBacnetErrorCode(678511419)1.0$ @*/
/* Generated Tue Apr 21 15:30:28 EDT 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */

  /**
   * Ordinal value for other.
   */
  public static final int OTHER = 0;
  /**
   * Ordinal value for authenticationFailed.
   */
  public static final int AUTHENTICATION_FAILED = 1;
  /**
   * Ordinal value for configurationInProgress.
   */
  public static final int CONFIGURATION_IN_PROGRESS = 2;
  /**
   * Ordinal value for deviceBusy.
   */
  public static final int DEVICE_BUSY = 3;
  /**
   * Ordinal value for dynamicCreationNotSupported.
   */
  public static final int DYNAMIC_CREATION_NOT_SUPPORTED = 4;
  /**
   * Ordinal value for fileAccessDenied.
   */
  public static final int FILE_ACCESS_DENIED = 5;
  /**
   * Ordinal value for incompatibleSecurityLevels.
   */
  public static final int INCOMPATIBLE_SECURITY_LEVELS = 6;
  /**
   * Ordinal value for inconsistentParameters.
   */
  public static final int INCONSISTENT_PARAMETERS = 7;
  /**
   * Ordinal value for inconsistentSelectionCriterion.
   */
  public static final int INCONSISTENT_SELECTION_CRITERION = 8;
  /**
   * Ordinal value for invalidDataType.
   */
  public static final int INVALID_DATA_TYPE = 9;
  /**
   * Ordinal value for invalidFileAccessMethod.
   */
  public static final int INVALID_FILE_ACCESS_METHOD = 10;
  /**
   * Ordinal value for invalidFileStartPosition.
   */
  public static final int INVALID_FILE_START_POSITION = 11;
  /**
   * Ordinal value for invalidOperatorName.
   */
  public static final int INVALID_OPERATOR_NAME = 12;
  /**
   * Ordinal value for invalidParameterDataType.
   */
  public static final int INVALID_PARAMETER_DATA_TYPE = 13;
  /**
   * Ordinal value for invalidTimeStamp.
   */
  public static final int INVALID_TIME_STAMP = 14;
  /**
   * Ordinal value for keyGenerationError.
   */
  public static final int KEY_GENERATION_ERROR = 15;
  /**
   * Ordinal value for missingRequiredParameter.
   */
  public static final int MISSING_REQUIRED_PARAMETER = 16;
  /**
   * Ordinal value for noObjectsOfSpecifiedType.
   */
  public static final int NO_OBJECTS_OF_SPECIFIED_TYPE = 17;
  /**
   * Ordinal value for noSpaceForObject.
   */
  public static final int NO_SPACE_FOR_OBJECT = 18;
  /**
   * Ordinal value for noSpaceToAddListElement.
   */
  public static final int NO_SPACE_TO_ADD_LIST_ELEMENT = 19;
  /**
   * Ordinal value for noSpaceToWriteProperty.
   */
  public static final int NO_SPACE_TO_WRITE_PROPERTY = 20;
  /**
   * Ordinal value for noVtSessionsAvailable.
   */
  public static final int NO_VT_SESSIONS_AVAILABLE = 21;
  /**
   * Ordinal value for propertyIsNotA_List.
   */
  public static final int PROPERTY_IS_NOT_A_LIST = 22;
  /**
   * Ordinal value for objectDeletionNotPermitted.
   */
  public static final int OBJECT_DELETION_NOT_PERMITTED = 23;
  /**
   * Ordinal value for objectIdentifierAlreadyExists.
   */
  public static final int OBJECT_IDENTIFIER_ALREADY_EXISTS = 24;
  /**
   * Ordinal value for operationalProblem.
   */
  public static final int OPERATIONAL_PROBLEM = 25;
  /**
   * Ordinal value for passwordFailure.
   */
  public static final int PASSWORD_FAILURE = 26;
  /**
   * Ordinal value for readAccessDenied.
   */
  public static final int READ_ACCESS_DENIED = 27;
  /**
   * Ordinal value for securityNotSupported.
   */
  public static final int SECURITY_NOT_SUPPORTED = 28;
  /**
   * Ordinal value for serviceRequestDenied.
   */
  public static final int SERVICE_REQUEST_DENIED = 29;
  /**
   * Ordinal value for timeout.
   */
  public static final int TIMEOUT = 30;
  /**
   * Ordinal value for unknownObject.
   */
  public static final int UNKNOWN_OBJECT = 31;
  /**
   * Ordinal value for unknownProperty.
   */
  public static final int UNKNOWN_PROPERTY = 32;
  /**
   * Ordinal value for removed.
   */
  public static final int REMOVED = 33;
  /**
   * Ordinal value for unknownVtClass.
   */
  public static final int UNKNOWN_VT_CLASS = 34;
  /**
   * Ordinal value for unknownVtSession.
   */
  public static final int UNKNOWN_VT_SESSION = 35;
  /**
   * Ordinal value for unsupportedObjectType.
   */
  public static final int UNSUPPORTED_OBJECT_TYPE = 36;
  /**
   * Ordinal value for valueOutOfRange.
   */
  public static final int VALUE_OUT_OF_RANGE = 37;
  /**
   * Ordinal value for vtSessionAlreadyClosed.
   */
  public static final int VT_SESSION_ALREADY_CLOSED = 38;
  /**
   * Ordinal value for vtSessionTerminationFailure.
   */
  public static final int VT_SESSION_TERMINATION_FAILURE = 39;
  /**
   * Ordinal value for writeAccessDenied.
   */
  public static final int WRITE_ACCESS_DENIED = 40;
  /**
   * Ordinal value for characterSetNotSupported.
   */
  public static final int CHARACTER_SET_NOT_SUPPORTED = 41;
  /**
   * Ordinal value for invalidArrayIndex.
   */
  public static final int INVALID_ARRAY_INDEX = 42;
  /**
   * Ordinal value for covSubscriptionFailed.
   */
  public static final int COV_SUBSCRIPTION_FAILED = 43;
  /**
   * Ordinal value for notCovProperty.
   */
  public static final int NOT_COV_PROPERTY = 44;
  /**
   * Ordinal value for optionalFunctionalityNotSupported.
   */
  public static final int OPTIONAL_FUNCTIONALITY_NOT_SUPPORTED = 45;
  /**
   * Ordinal value for invalidConfigurationData.
   */
  public static final int INVALID_CONFIGURATION_DATA = 46;
  /**
   * Ordinal value for datatypeNotSupported.
   */
  public static final int DATATYPE_NOT_SUPPORTED = 47;
  /**
   * Ordinal value for duplicateName.
   */
  public static final int DUPLICATE_NAME = 48;
  /**
   * Ordinal value for duplicateObjectId.
   */
  public static final int DUPLICATE_OBJECT_ID = 49;
  /**
   * Ordinal value for propertyIsNotAnArray.
   */
  public static final int PROPERTY_IS_NOT_AN_ARRAY = 50;
  /**
   * Ordinal value for abortBufferOverflow.
   */
  public static final int ABORT_BUFFER_OVERFLOW = 51;
  /**
   * Ordinal value for abortInvalidApduInThisState.
   */
  public static final int ABORT_INVALID_APDU_IN_THIS_STATE = 52;
  /**
   * Ordinal value for abortPreemptedByHigherPriorityTask.
   */
  public static final int ABORT_PREEMPTED_BY_HIGHER_PRIORITY_TASK = 53;
  /**
   * Ordinal value for abortSegmentationNotSupported.
   */
  public static final int ABORT_SEGMENTATION_NOT_SUPPORTED = 54;
  /**
   * Ordinal value for abortProprietary.
   */
  public static final int ABORT_PROPRIETARY = 55;
  /**
   * Ordinal value for abortOther.
   */
  public static final int ABORT_OTHER = 56;
  /**
   * Ordinal value for invalidTag.
   */
  public static final int INVALID_TAG = 57;
  /**
   * Ordinal value for networkDown.
   */
  public static final int NETWORK_DOWN = 58;
  /**
   * Ordinal value for rejectBufferOverflow.
   */
  public static final int REJECT_BUFFER_OVERFLOW = 59;
  /**
   * Ordinal value for rejectInconsistentParameters.
   */
  public static final int REJECT_INCONSISTENT_PARAMETERS = 60;
  /**
   * Ordinal value for rejectInvalidParameterDataType.
   */
  public static final int REJECT_INVALID_PARAMETER_DATA_TYPE = 61;
  /**
   * Ordinal value for rejectInvalidTag.
   */
  public static final int REJECT_INVALID_TAG = 62;
  /**
   * Ordinal value for rejectMissingRequiredParameter.
   */
  public static final int REJECT_MISSING_REQUIRED_PARAMETER = 63;
  /**
   * Ordinal value for rejectParameterOutOfRange.
   */
  public static final int REJECT_PARAMETER_OUT_OF_RANGE = 64;
  /**
   * Ordinal value for rejectTooManyArguments.
   */
  public static final int REJECT_TOO_MANY_ARGUMENTS = 65;
  /**
   * Ordinal value for rejectUndefinedEnumeration.
   */
  public static final int REJECT_UNDEFINED_ENUMERATION = 66;
  /**
   * Ordinal value for rejectUnrecognizedService.
   */
  public static final int REJECT_UNRECOGNIZED_SERVICE = 67;
  /**
   * Ordinal value for rejectProprietary.
   */
  public static final int REJECT_PROPRIETARY = 68;
  /**
   * Ordinal value for rejectOther.
   */
  public static final int REJECT_OTHER = 69;
  /**
   * Ordinal value for unknownDevice.
   */
  public static final int UNKNOWN_DEVICE = 70;
  /**
   * Ordinal value for unknownRoute.
   */
  public static final int UNKNOWN_ROUTE = 71;
  /**
   * Ordinal value for valueNotInitialized.
   */
  public static final int VALUE_NOT_INITIALIZED = 72;
  /**
   * Ordinal value for invalidEventState.
   */
  public static final int INVALID_EVENT_STATE = 73;
  /**
   * Ordinal value for noAlarmConfigured.
   */
  public static final int NO_ALARM_CONFIGURED = 74;
  /**
   * Ordinal value for logBufferFull.
   */
  public static final int LOG_BUFFER_FULL = 75;
  /**
   * Ordinal value for loggedValuePurged.
   */
  public static final int LOGGED_VALUE_PURGED = 76;
  /**
   * Ordinal value for noPropertySpecified.
   */
  public static final int NO_PROPERTY_SPECIFIED = 77;
  /**
   * Ordinal value for notConfiguredForTriggeredLogging.
   */
  public static final int NOT_CONFIGURED_FOR_TRIGGERED_LOGGING = 78;
  /**
   * Ordinal value for unknownSubscription.
   */
  public static final int UNKNOWN_SUBSCRIPTION = 79;
  /**
   * Ordinal value for parameterOutOfRange.
   */
  public static final int PARAMETER_OUT_OF_RANGE = 80;
  /**
   * Ordinal value for listElementNotFound.
   */
  public static final int LIST_ELEMENT_NOT_FOUND = 81;
  /**
   * Ordinal value for busy.
   */
  public static final int BUSY = 82;
  /**
   * Ordinal value for communicationDisabled.
   */
  public static final int COMMUNICATION_DISABLED = 83;
  /**
   * Ordinal value for success.
   */
  public static final int SUCCESS = 84;
  /**
   * Ordinal value for accessDenied.
   */
  public static final int ACCESS_DENIED = 85;
  /**
   * Ordinal value for badDestinationAddress.
   */
  public static final int BAD_DESTINATION_ADDRESS = 86;
  /**
   * Ordinal value for badDestinationDeviceId.
   */
  public static final int BAD_DESTINATION_DEVICE_ID = 87;
  /**
   * Ordinal value for badSignature.
   */
  public static final int BAD_SIGNATURE = 88;
  /**
   * Ordinal value for badSourceAddress.
   */
  public static final int BAD_SOURCE_ADDRESS = 89;
  /**
   * Ordinal value for badTimestamp.
   */
  public static final int BAD_TIMESTAMP = 90;
  /**
   * Ordinal value for cannotUseKey.
   */
  public static final int CANNOT_USE_KEY = 91;
  /**
   * Ordinal value for cannotVerifyMessageId.
   */
  public static final int CANNOT_VERIFY_MESSAGE_ID = 92;
  /**
   * Ordinal value for correctKeyRevision.
   */
  public static final int CORRECT_KEY_REVISION = 93;
  /**
   * Ordinal value for destinationDeviceIdRequired.
   */
  public static final int DESTINATION_DEVICE_ID_REQUIRED = 94;
  /**
   * Ordinal value for duplicateMessage.
   */
  public static final int DUPLICATE_MESSAGE = 95;
  /**
   * Ordinal value for encryptionNotConfigured.
   */
  public static final int ENCRYPTION_NOT_CONFIGURED = 96;
  /**
   * Ordinal value for encryptionRequired.
   */
  public static final int ENCRYPTION_REQUIRED = 97;
  /**
   * Ordinal value for incorrectKey.
   */
  public static final int INCORRECT_KEY = 98;
  /**
   * Ordinal value for invalidKeyData.
   */
  public static final int INVALID_KEY_DATA = 99;
  /**
   * Ordinal value for keyUpdateInProgress.
   */
  public static final int KEY_UPDATE_IN_PROGRESS = 100;
  /**
   * Ordinal value for malformedMessage.
   */
  public static final int MALFORMED_MESSAGE = 101;
  /**
   * Ordinal value for notKeyServer.
   */
  public static final int NOT_KEY_SERVER = 102;
  /**
   * Ordinal value for securityNotConfigured.
   */
  public static final int SECURITY_NOT_CONFIGURED = 103;
  /**
   * Ordinal value for sourceSecurityRequired.
   */
  public static final int SOURCE_SECURITY_REQUIRED = 104;
  /**
   * Ordinal value for tooManyKeys.
   */
  public static final int TOO_MANY_KEYS = 105;
  /**
   * Ordinal value for unknownAuthenticationType.
   */
  public static final int UNKNOWN_AUTHENTICATION_TYPE = 106;
  /**
   * Ordinal value for unknownKey.
   */
  public static final int UNKNOWN_KEY = 107;
  /**
   * Ordinal value for unknownKeyRevision.
   */
  public static final int UNKNOWN_KEY_REVISION = 108;
  /**
   * Ordinal value for unknownSourceMessage.
   */
  public static final int UNKNOWN_SOURCE_MESSAGE = 109;
  /**
   * Ordinal value for notRouterToDnet.
   */
  public static final int NOT_ROUTER_TO_DNET = 110;
  /**
   * Ordinal value for routerBusy.
   */
  public static final int ROUTER_BUSY = 111;
  /**
   * Ordinal value for unknownNetworkMessage.
   */
  public static final int UNKNOWN_NETWORK_MESSAGE = 112;
  /**
   * Ordinal value for messageTooLong.
   */
  public static final int MESSAGE_TOO_LONG = 113;
  /**
   * Ordinal value for securityError.
   */
  public static final int SECURITY_ERROR = 114;
  /**
   * Ordinal value for addressingError.
   */
  public static final int ADDRESSING_ERROR = 115;
  /**
   * Ordinal value for writeBdtFailed.
   */
  public static final int WRITE_BDT_FAILED = 116;
  /**
   * Ordinal value for readBdtFailed.
   */
  public static final int READ_BDT_FAILED = 117;
  /**
   * Ordinal value for registerForeignDeviceFailed.
   */
  public static final int REGISTER_FOREIGN_DEVICE_FAILED = 118;
  /**
   * Ordinal value for readFdtFailed.
   */
  public static final int READ_FDT_FAILED = 119;
  /**
   * Ordinal value for deleteFdtEntryFailed.
   */
  public static final int DELETE_FDT_ENTRY_FAILED = 120;
  /**
   * Ordinal value for distributeBroadcastFailed.
   */
  public static final int DISTRIBUTE_BROADCAST_FAILED = 121;
  /**
   * Ordinal value for unknownFileSize.
   */
  public static final int UNKNOWN_FILE_SIZE = 122;
  /**
   * Ordinal value for abortApduTooLong.
   */
  public static final int ABORT_APDU_TOO_LONG = 123;
  /**
   * Ordinal value for abortApplicationExceededReplyTime.
   */
  public static final int ABORT_APPLICATION_EXCEEDED_REPLY_TIME = 124;
  /**
   * Ordinal value for abortOutOfResources.
   */
  public static final int ABORT_OUT_OF_RESOURCES = 125;
  /**
   * Ordinal value for abortTsmTimeout.
   */
  public static final int ABORT_TSM_TIMEOUT = 126;
  /**
   * Ordinal value for abortWindowSizeOutOfRange.
   */
  public static final int ABORT_WINDOW_SIZE_OUT_OF_RANGE = 127;
  /**
   * Ordinal value for fileFull.
   */
  public static final int FILE_FULL = 128;
  /**
   * Ordinal value for inconsistentConfiguration.
   */
  public static final int INCONSISTENT_CONFIGURATION = 129;
  /**
   * Ordinal value for inconsistentObjectType.
   */
  public static final int INCONSISTENT_OBJECT_TYPE = 130;
  /**
   * Ordinal value for internalError.
   */
  public static final int INTERNAL_ERROR = 131;
  /**
   * Ordinal value for notConfigured.
   */
  public static final int NOT_CONFIGURED = 132;
  /**
   * Ordinal value for outOfMemory.
   */
  public static final int OUT_OF_MEMORY = 133;
  /**
   * Ordinal value for valueTooLong.
   */
  public static final int VALUE_TOO_LONG = 134;
  /**
   * Ordinal value for abortInsufficientSecurity.
   */
  public static final int ABORT_INSUFFICIENT_SECURITY = 135;
  /**
   * Ordinal value for abortSecurityError.
   */
  public static final int ABORT_SECURITY_ERROR = 136;
  /**
   * Ordinal value for Null Event for BACnet in Niagara..
   */
  public static final int  NULL_VALUE_EVENT = 355;

  /**
   * BBacnetErrorCode constant for other.
   */
  public static final BBacnetErrorCode other = new BBacnetErrorCode(OTHER);
  /**
   * BBacnetErrorCode constant for authenticationFailed.
   */
  public static final BBacnetErrorCode authenticationFailed = new BBacnetErrorCode(AUTHENTICATION_FAILED);
  /**
   * BBacnetErrorCode constant for configurationInProgress.
   */
  public static final BBacnetErrorCode configurationInProgress = new BBacnetErrorCode(CONFIGURATION_IN_PROGRESS);
  /**
   * BBacnetErrorCode constant for deviceBusy.
   */
  public static final BBacnetErrorCode deviceBusy = new BBacnetErrorCode(DEVICE_BUSY);
  /**
   * BBacnetErrorCode constant for dynamicCreationNotSupported.
   */
  public static final BBacnetErrorCode dynamicCreationNotSupported = new BBacnetErrorCode(DYNAMIC_CREATION_NOT_SUPPORTED);
  /**
   * BBacnetErrorCode constant for fileAccessDenied.
   */
  public static final BBacnetErrorCode fileAccessDenied = new BBacnetErrorCode(FILE_ACCESS_DENIED);
  /**
   * BBacnetErrorCode constant for incompatibleSecurityLevels.
   */
  public static final BBacnetErrorCode incompatibleSecurityLevels = new BBacnetErrorCode(INCOMPATIBLE_SECURITY_LEVELS);
  /**
   * BBacnetErrorCode constant for inconsistentParameters.
   */
  public static final BBacnetErrorCode inconsistentParameters = new BBacnetErrorCode(INCONSISTENT_PARAMETERS);
  /**
   * BBacnetErrorCode constant for inconsistentSelectionCriterion.
   */
  public static final BBacnetErrorCode inconsistentSelectionCriterion = new BBacnetErrorCode(INCONSISTENT_SELECTION_CRITERION);
  /**
   * BBacnetErrorCode constant for invalidDataType.
   */
  public static final BBacnetErrorCode invalidDataType = new BBacnetErrorCode(INVALID_DATA_TYPE);
  /**
   * BBacnetErrorCode constant for invalidFileAccessMethod.
   */
  public static final BBacnetErrorCode invalidFileAccessMethod = new BBacnetErrorCode(INVALID_FILE_ACCESS_METHOD);
  /**
   * BBacnetErrorCode constant for invalidFileStartPosition.
   */
  public static final BBacnetErrorCode invalidFileStartPosition = new BBacnetErrorCode(INVALID_FILE_START_POSITION);
  /**
   * BBacnetErrorCode constant for invalidOperatorName.
   */
  public static final BBacnetErrorCode invalidOperatorName = new BBacnetErrorCode(INVALID_OPERATOR_NAME);
  /**
   * BBacnetErrorCode constant for invalidParameterDataType.
   */
  public static final BBacnetErrorCode invalidParameterDataType = new BBacnetErrorCode(INVALID_PARAMETER_DATA_TYPE);
  /**
   * BBacnetErrorCode constant for invalidTimeStamp.
   */
  public static final BBacnetErrorCode invalidTimeStamp = new BBacnetErrorCode(INVALID_TIME_STAMP);
  /**
   * BBacnetErrorCode constant for keyGenerationError.
   */
  public static final BBacnetErrorCode keyGenerationError = new BBacnetErrorCode(KEY_GENERATION_ERROR);
  /**
   * BBacnetErrorCode constant for missingRequiredParameter.
   */
  public static final BBacnetErrorCode missingRequiredParameter = new BBacnetErrorCode(MISSING_REQUIRED_PARAMETER);
  /**
   * BBacnetErrorCode constant for noObjectsOfSpecifiedType.
   */
  public static final BBacnetErrorCode noObjectsOfSpecifiedType = new BBacnetErrorCode(NO_OBJECTS_OF_SPECIFIED_TYPE);
  /**
   * BBacnetErrorCode constant for noSpaceForObject.
   */
  public static final BBacnetErrorCode noSpaceForObject = new BBacnetErrorCode(NO_SPACE_FOR_OBJECT);
  /**
   * BBacnetErrorCode constant for noSpaceToAddListElement.
   */
  public static final BBacnetErrorCode noSpaceToAddListElement = new BBacnetErrorCode(NO_SPACE_TO_ADD_LIST_ELEMENT);
  /**
   * BBacnetErrorCode constant for noSpaceToWriteProperty.
   */
  public static final BBacnetErrorCode noSpaceToWriteProperty = new BBacnetErrorCode(NO_SPACE_TO_WRITE_PROPERTY);
  /**
   * BBacnetErrorCode constant for noVtSessionsAvailable.
   */
  public static final BBacnetErrorCode noVtSessionsAvailable = new BBacnetErrorCode(NO_VT_SESSIONS_AVAILABLE);
  /**
   * BBacnetErrorCode constant for propertyIsNotA_List.
   */
  public static final BBacnetErrorCode propertyIsNotA_List = new BBacnetErrorCode(PROPERTY_IS_NOT_A_LIST);
  /**
   * BBacnetErrorCode constant for objectDeletionNotPermitted.
   */
  public static final BBacnetErrorCode objectDeletionNotPermitted = new BBacnetErrorCode(OBJECT_DELETION_NOT_PERMITTED);
  /**
   * BBacnetErrorCode constant for objectIdentifierAlreadyExists.
   */
  public static final BBacnetErrorCode objectIdentifierAlreadyExists = new BBacnetErrorCode(OBJECT_IDENTIFIER_ALREADY_EXISTS);
  /**
   * BBacnetErrorCode constant for operationalProblem.
   */
  public static final BBacnetErrorCode operationalProblem = new BBacnetErrorCode(OPERATIONAL_PROBLEM);
  /**
   * BBacnetErrorCode constant for passwordFailure.
   */
  public static final BBacnetErrorCode passwordFailure = new BBacnetErrorCode(PASSWORD_FAILURE);
  /**
   * BBacnetErrorCode constant for readAccessDenied.
   */
  public static final BBacnetErrorCode readAccessDenied = new BBacnetErrorCode(READ_ACCESS_DENIED);
  /**
   * BBacnetErrorCode constant for securityNotSupported.
   */
  public static final BBacnetErrorCode securityNotSupported = new BBacnetErrorCode(SECURITY_NOT_SUPPORTED);
  /**
   * BBacnetErrorCode constant for serviceRequestDenied.
   */
  public static final BBacnetErrorCode serviceRequestDenied = new BBacnetErrorCode(SERVICE_REQUEST_DENIED);
  /**
   * BBacnetErrorCode constant for timeout.
   */
  public static final BBacnetErrorCode timeout = new BBacnetErrorCode(TIMEOUT);
  /**
   * BBacnetErrorCode constant for unknownObject.
   */
  public static final BBacnetErrorCode unknownObject = new BBacnetErrorCode(UNKNOWN_OBJECT);
  /**
   * BBacnetErrorCode constant for unknownProperty.
   */
  public static final BBacnetErrorCode unknownProperty = new BBacnetErrorCode(UNKNOWN_PROPERTY);
  /**
   * BBacnetErrorCode constant for removed.
   */
  public static final BBacnetErrorCode removed = new BBacnetErrorCode(REMOVED);
  /**
   * BBacnetErrorCode constant for unknownVtClass.
   */
  public static final BBacnetErrorCode unknownVtClass = new BBacnetErrorCode(UNKNOWN_VT_CLASS);
  /**
   * BBacnetErrorCode constant for unknownVtSession.
   */
  public static final BBacnetErrorCode unknownVtSession = new BBacnetErrorCode(UNKNOWN_VT_SESSION);
  /**
   * BBacnetErrorCode constant for unsupportedObjectType.
   */
  public static final BBacnetErrorCode unsupportedObjectType = new BBacnetErrorCode(UNSUPPORTED_OBJECT_TYPE);
  /**
   * BBacnetErrorCode constant for valueOutOfRange.
   */
  public static final BBacnetErrorCode valueOutOfRange = new BBacnetErrorCode(VALUE_OUT_OF_RANGE);
  /**
   * BBacnetErrorCode constant for vtSessionAlreadyClosed.
   */
  public static final BBacnetErrorCode vtSessionAlreadyClosed = new BBacnetErrorCode(VT_SESSION_ALREADY_CLOSED);
  /**
   * BBacnetErrorCode constant for vtSessionTerminationFailure.
   */
  public static final BBacnetErrorCode vtSessionTerminationFailure = new BBacnetErrorCode(VT_SESSION_TERMINATION_FAILURE);
  /**
   * BBacnetErrorCode constant for writeAccessDenied.
   */
  public static final BBacnetErrorCode writeAccessDenied = new BBacnetErrorCode(WRITE_ACCESS_DENIED);
  /**
   * BBacnetErrorCode constant for characterSetNotSupported.
   */
  public static final BBacnetErrorCode characterSetNotSupported = new BBacnetErrorCode(CHARACTER_SET_NOT_SUPPORTED);
  /**
   * BBacnetErrorCode constant for invalidArrayIndex.
   */
  public static final BBacnetErrorCode invalidArrayIndex = new BBacnetErrorCode(INVALID_ARRAY_INDEX);
  /**
   * BBacnetErrorCode constant for covSubscriptionFailed.
   */
  public static final BBacnetErrorCode covSubscriptionFailed = new BBacnetErrorCode(COV_SUBSCRIPTION_FAILED);
  /**
   * BBacnetErrorCode constant for notCovProperty.
   */
  public static final BBacnetErrorCode notCovProperty = new BBacnetErrorCode(NOT_COV_PROPERTY);
  /**
   * BBacnetErrorCode constant for optionalFunctionalityNotSupported.
   */
  public static final BBacnetErrorCode optionalFunctionalityNotSupported = new BBacnetErrorCode(OPTIONAL_FUNCTIONALITY_NOT_SUPPORTED);
  /**
   * BBacnetErrorCode constant for invalidConfigurationData.
   */
  public static final BBacnetErrorCode invalidConfigurationData = new BBacnetErrorCode(INVALID_CONFIGURATION_DATA);
  /**
   * BBacnetErrorCode constant for datatypeNotSupported.
   */
  public static final BBacnetErrorCode datatypeNotSupported = new BBacnetErrorCode(DATATYPE_NOT_SUPPORTED);
  /**
   * BBacnetErrorCode constant for duplicateName.
   */
  public static final BBacnetErrorCode duplicateName = new BBacnetErrorCode(DUPLICATE_NAME);
  /**
   * BBacnetErrorCode constant for duplicateObjectId.
   */
  public static final BBacnetErrorCode duplicateObjectId = new BBacnetErrorCode(DUPLICATE_OBJECT_ID);
  /**
   * BBacnetErrorCode constant for propertyIsNotAnArray.
   */
  public static final BBacnetErrorCode propertyIsNotAnArray = new BBacnetErrorCode(PROPERTY_IS_NOT_AN_ARRAY);
  /**
   * BBacnetErrorCode constant for abortBufferOverflow.
   */
  public static final BBacnetErrorCode abortBufferOverflow = new BBacnetErrorCode(ABORT_BUFFER_OVERFLOW);
  /**
   * BBacnetErrorCode constant for abortInvalidApduInThisState.
   */
  public static final BBacnetErrorCode abortInvalidApduInThisState = new BBacnetErrorCode(ABORT_INVALID_APDU_IN_THIS_STATE);
  /**
   * BBacnetErrorCode constant for abortPreemptedByHigherPriorityTask.
   */
  public static final BBacnetErrorCode abortPreemptedByHigherPriorityTask = new BBacnetErrorCode(ABORT_PREEMPTED_BY_HIGHER_PRIORITY_TASK);
  /**
   * BBacnetErrorCode constant for abortSegmentationNotSupported.
   */
  public static final BBacnetErrorCode abortSegmentationNotSupported = new BBacnetErrorCode(ABORT_SEGMENTATION_NOT_SUPPORTED);
  /**
   * BBacnetErrorCode constant for abortProprietary.
   */
  public static final BBacnetErrorCode abortProprietary = new BBacnetErrorCode(ABORT_PROPRIETARY);
  /**
   * BBacnetErrorCode constant for abortOther.
   */
  public static final BBacnetErrorCode abortOther = new BBacnetErrorCode(ABORT_OTHER);
  /**
   * BBacnetErrorCode constant for invalidTag.
   */
  public static final BBacnetErrorCode invalidTag = new BBacnetErrorCode(INVALID_TAG);
  /**
   * BBacnetErrorCode constant for networkDown.
   */
  public static final BBacnetErrorCode networkDown = new BBacnetErrorCode(NETWORK_DOWN);
  /**
   * BBacnetErrorCode constant for rejectBufferOverflow.
   */
  public static final BBacnetErrorCode rejectBufferOverflow = new BBacnetErrorCode(REJECT_BUFFER_OVERFLOW);
  /**
   * BBacnetErrorCode constant for rejectInconsistentParameters.
   */
  public static final BBacnetErrorCode rejectInconsistentParameters = new BBacnetErrorCode(REJECT_INCONSISTENT_PARAMETERS);
  /**
   * BBacnetErrorCode constant for rejectInvalidParameterDataType.
   */
  public static final BBacnetErrorCode rejectInvalidParameterDataType = new BBacnetErrorCode(REJECT_INVALID_PARAMETER_DATA_TYPE);
  /**
   * BBacnetErrorCode constant for rejectInvalidTag.
   */
  public static final BBacnetErrorCode rejectInvalidTag = new BBacnetErrorCode(REJECT_INVALID_TAG);
  /**
   * BBacnetErrorCode constant for rejectMissingRequiredParameter.
   */
  public static final BBacnetErrorCode rejectMissingRequiredParameter = new BBacnetErrorCode(REJECT_MISSING_REQUIRED_PARAMETER);
  /**
   * BBacnetErrorCode constant for rejectParameterOutOfRange.
   */
  public static final BBacnetErrorCode rejectParameterOutOfRange = new BBacnetErrorCode(REJECT_PARAMETER_OUT_OF_RANGE);
  /**
   * BBacnetErrorCode constant for rejectTooManyArguments.
   */
  public static final BBacnetErrorCode rejectTooManyArguments = new BBacnetErrorCode(REJECT_TOO_MANY_ARGUMENTS);
  /**
   * BBacnetErrorCode constant for rejectUndefinedEnumeration.
   */
  public static final BBacnetErrorCode rejectUndefinedEnumeration = new BBacnetErrorCode(REJECT_UNDEFINED_ENUMERATION);
  /**
   * BBacnetErrorCode constant for rejectUnrecognizedService.
   */
  public static final BBacnetErrorCode rejectUnrecognizedService = new BBacnetErrorCode(REJECT_UNRECOGNIZED_SERVICE);
  /**
   * BBacnetErrorCode constant for rejectProprietary.
   */
  public static final BBacnetErrorCode rejectProprietary = new BBacnetErrorCode(REJECT_PROPRIETARY);
  /**
   * BBacnetErrorCode constant for rejectOther.
   */
  public static final BBacnetErrorCode rejectOther = new BBacnetErrorCode(REJECT_OTHER);
  /**
   * BBacnetErrorCode constant for unknownDevice.
   */
  public static final BBacnetErrorCode unknownDevice = new BBacnetErrorCode(UNKNOWN_DEVICE);
  /**
   * BBacnetErrorCode constant for unknownRoute.
   */
  public static final BBacnetErrorCode unknownRoute = new BBacnetErrorCode(UNKNOWN_ROUTE);
  /**
   * BBacnetErrorCode constant for valueNotInitialized.
   */
  public static final BBacnetErrorCode valueNotInitialized = new BBacnetErrorCode(VALUE_NOT_INITIALIZED);
  /**
   * BBacnetErrorCode constant for invalidEventState.
   */
  public static final BBacnetErrorCode invalidEventState = new BBacnetErrorCode(INVALID_EVENT_STATE);
  /**
   * BBacnetErrorCode constant for noAlarmConfigured.
   */
  public static final BBacnetErrorCode noAlarmConfigured = new BBacnetErrorCode(NO_ALARM_CONFIGURED);
  /**
   * BBacnetErrorCode constant for logBufferFull.
   */
  public static final BBacnetErrorCode logBufferFull = new BBacnetErrorCode(LOG_BUFFER_FULL);
  /**
   * BBacnetErrorCode constant for loggedValuePurged.
   */
  public static final BBacnetErrorCode loggedValuePurged = new BBacnetErrorCode(LOGGED_VALUE_PURGED);
  /**
   * BBacnetErrorCode constant for noPropertySpecified.
   */
  public static final BBacnetErrorCode noPropertySpecified = new BBacnetErrorCode(NO_PROPERTY_SPECIFIED);
  /**
   * BBacnetErrorCode constant for notConfiguredForTriggeredLogging.
   */
  public static final BBacnetErrorCode notConfiguredForTriggeredLogging = new BBacnetErrorCode(NOT_CONFIGURED_FOR_TRIGGERED_LOGGING);
  /**
   * BBacnetErrorCode constant for unknownSubscription.
   */
  public static final BBacnetErrorCode unknownSubscription = new BBacnetErrorCode(UNKNOWN_SUBSCRIPTION);
  /**
   * BBacnetErrorCode constant for parameterOutOfRange.
   */
  public static final BBacnetErrorCode parameterOutOfRange = new BBacnetErrorCode(PARAMETER_OUT_OF_RANGE);
  /**
   * BBacnetErrorCode constant for listElementNotFound.
   */
  public static final BBacnetErrorCode listElementNotFound = new BBacnetErrorCode(LIST_ELEMENT_NOT_FOUND);
  /**
   * BBacnetErrorCode constant for busy.
   */
  public static final BBacnetErrorCode busy = new BBacnetErrorCode(BUSY);
  /**
   * BBacnetErrorCode constant for communicationDisabled.
   */
  public static final BBacnetErrorCode communicationDisabled = new BBacnetErrorCode(COMMUNICATION_DISABLED);
  /**
   * BBacnetErrorCode constant for success.
   */
  public static final BBacnetErrorCode success = new BBacnetErrorCode(SUCCESS);
  /**
   * BBacnetErrorCode constant for accessDenied.
   */
  public static final BBacnetErrorCode accessDenied = new BBacnetErrorCode(ACCESS_DENIED);
  /**
   * BBacnetErrorCode constant for badDestinationAddress.
   */
  public static final BBacnetErrorCode badDestinationAddress = new BBacnetErrorCode(BAD_DESTINATION_ADDRESS);
  /**
   * BBacnetErrorCode constant for badDestinationDeviceId.
   */
  public static final BBacnetErrorCode badDestinationDeviceId = new BBacnetErrorCode(BAD_DESTINATION_DEVICE_ID);
  /**
   * BBacnetErrorCode constant for badSignature.
   */
  public static final BBacnetErrorCode badSignature = new BBacnetErrorCode(BAD_SIGNATURE);
  /**
   * BBacnetErrorCode constant for badSourceAddress.
   */
  public static final BBacnetErrorCode badSourceAddress = new BBacnetErrorCode(BAD_SOURCE_ADDRESS);
  /**
   * BBacnetErrorCode constant for badTimestamp.
   */
  public static final BBacnetErrorCode badTimestamp = new BBacnetErrorCode(BAD_TIMESTAMP);
  /**
   * BBacnetErrorCode constant for cannotUseKey.
   */
  public static final BBacnetErrorCode cannotUseKey = new BBacnetErrorCode(CANNOT_USE_KEY);
  /**
   * BBacnetErrorCode constant for cannotVerifyMessageId.
   */
  public static final BBacnetErrorCode cannotVerifyMessageId = new BBacnetErrorCode(CANNOT_VERIFY_MESSAGE_ID);
  /**
   * BBacnetErrorCode constant for correctKeyRevision.
   */
  public static final BBacnetErrorCode correctKeyRevision = new BBacnetErrorCode(CORRECT_KEY_REVISION);
  /**
   * BBacnetErrorCode constant for destinationDeviceIdRequired.
   */
  public static final BBacnetErrorCode destinationDeviceIdRequired = new BBacnetErrorCode(DESTINATION_DEVICE_ID_REQUIRED);
  /**
   * BBacnetErrorCode constant for duplicateMessage.
   */
  public static final BBacnetErrorCode duplicateMessage = new BBacnetErrorCode(DUPLICATE_MESSAGE);
  /**
   * BBacnetErrorCode constant for encryptionNotConfigured.
   */
  public static final BBacnetErrorCode encryptionNotConfigured = new BBacnetErrorCode(ENCRYPTION_NOT_CONFIGURED);
  /**
   * BBacnetErrorCode constant for encryptionRequired.
   */
  public static final BBacnetErrorCode encryptionRequired = new BBacnetErrorCode(ENCRYPTION_REQUIRED);
  /**
   * BBacnetErrorCode constant for incorrectKey.
   */
  public static final BBacnetErrorCode incorrectKey = new BBacnetErrorCode(INCORRECT_KEY);
  /**
   * BBacnetErrorCode constant for invalidKeyData.
   */
  public static final BBacnetErrorCode invalidKeyData = new BBacnetErrorCode(INVALID_KEY_DATA);
  /**
   * BBacnetErrorCode constant for keyUpdateInProgress.
   */
  public static final BBacnetErrorCode keyUpdateInProgress = new BBacnetErrorCode(KEY_UPDATE_IN_PROGRESS);
  /**
   * BBacnetErrorCode constant for malformedMessage.
   */
  public static final BBacnetErrorCode malformedMessage = new BBacnetErrorCode(MALFORMED_MESSAGE);
  /**
   * BBacnetErrorCode constant for notKeyServer.
   */
  public static final BBacnetErrorCode notKeyServer = new BBacnetErrorCode(NOT_KEY_SERVER);
  /**
   * BBacnetErrorCode constant for securityNotConfigured.
   */
  public static final BBacnetErrorCode securityNotConfigured = new BBacnetErrorCode(SECURITY_NOT_CONFIGURED);
  /**
   * BBacnetErrorCode constant for sourceSecurityRequired.
   */
  public static final BBacnetErrorCode sourceSecurityRequired = new BBacnetErrorCode(SOURCE_SECURITY_REQUIRED);
  /**
   * BBacnetErrorCode constant for tooManyKeys.
   */
  public static final BBacnetErrorCode tooManyKeys = new BBacnetErrorCode(TOO_MANY_KEYS);
  /**
   * BBacnetErrorCode constant for unknownAuthenticationType.
   */
  public static final BBacnetErrorCode unknownAuthenticationType = new BBacnetErrorCode(UNKNOWN_AUTHENTICATION_TYPE);
  /**
   * BBacnetErrorCode constant for unknownKey.
   */
  public static final BBacnetErrorCode unknownKey = new BBacnetErrorCode(UNKNOWN_KEY);
  /**
   * BBacnetErrorCode constant for unknownKeyRevision.
   */
  public static final BBacnetErrorCode unknownKeyRevision = new BBacnetErrorCode(UNKNOWN_KEY_REVISION);
  /**
   * BBacnetErrorCode constant for unknownSourceMessage.
   */
  public static final BBacnetErrorCode unknownSourceMessage = new BBacnetErrorCode(UNKNOWN_SOURCE_MESSAGE);
  /**
   * BBacnetErrorCode constant for notRouterToDnet.
   */
  public static final BBacnetErrorCode notRouterToDnet = new BBacnetErrorCode(NOT_ROUTER_TO_DNET);
  /**
   * BBacnetErrorCode constant for routerBusy.
   */
  public static final BBacnetErrorCode routerBusy = new BBacnetErrorCode(ROUTER_BUSY);
  /**
   * BBacnetErrorCode constant for unknownNetworkMessage.
   */
  public static final BBacnetErrorCode unknownNetworkMessage = new BBacnetErrorCode(UNKNOWN_NETWORK_MESSAGE);
  /**
   * BBacnetErrorCode constant for messageTooLong.
   */
  public static final BBacnetErrorCode messageTooLong = new BBacnetErrorCode(MESSAGE_TOO_LONG);
  /**
   * BBacnetErrorCode constant for securityError.
   */
  public static final BBacnetErrorCode securityError = new BBacnetErrorCode(SECURITY_ERROR);
  /**
   * BBacnetErrorCode constant for addressingError.
   */
  public static final BBacnetErrorCode addressingError = new BBacnetErrorCode(ADDRESSING_ERROR);
  /**
   * BBacnetErrorCode constant for writeBdtFailed.
   */
  public static final BBacnetErrorCode writeBdtFailed = new BBacnetErrorCode(WRITE_BDT_FAILED);
  /**
   * BBacnetErrorCode constant for readBdtFailed.
   */
  public static final BBacnetErrorCode readBdtFailed = new BBacnetErrorCode(READ_BDT_FAILED);
  /**
   * BBacnetErrorCode constant for registerForeignDeviceFailed.
   */
  public static final BBacnetErrorCode registerForeignDeviceFailed = new BBacnetErrorCode(REGISTER_FOREIGN_DEVICE_FAILED);
  /**
   * BBacnetErrorCode constant for readFdtFailed.
   */
  public static final BBacnetErrorCode readFdtFailed = new BBacnetErrorCode(READ_FDT_FAILED);
  /**
   * BBacnetErrorCode constant for deleteFdtEntryFailed.
   */
  public static final BBacnetErrorCode deleteFdtEntryFailed = new BBacnetErrorCode(DELETE_FDT_ENTRY_FAILED);
  /**
   * BBacnetErrorCode constant for distributeBroadcastFailed.
   */
  public static final BBacnetErrorCode distributeBroadcastFailed = new BBacnetErrorCode(DISTRIBUTE_BROADCAST_FAILED);
  /**
   * BBacnetErrorCode constant for unknownFileSize.
   */
  public static final BBacnetErrorCode unknownFileSize = new BBacnetErrorCode(UNKNOWN_FILE_SIZE);
  /**
   * BBacnetErrorCode constant for abortApduTooLong.
   */
  public static final BBacnetErrorCode abortApduTooLong = new BBacnetErrorCode(ABORT_APDU_TOO_LONG);
  /**
   * BBacnetErrorCode constant for abortApplicationExceededReplyTime.
   */
  public static final BBacnetErrorCode abortApplicationExceededReplyTime = new BBacnetErrorCode(ABORT_APPLICATION_EXCEEDED_REPLY_TIME);
  /**
   * BBacnetErrorCode constant for abortOutOfResources.
   */
  public static final BBacnetErrorCode abortOutOfResources = new BBacnetErrorCode(ABORT_OUT_OF_RESOURCES);
  /**
   * BBacnetErrorCode constant for abortTsmTimeout.
   */
  public static final BBacnetErrorCode abortTsmTimeout = new BBacnetErrorCode(ABORT_TSM_TIMEOUT);
  /**
   * BBacnetErrorCode constant for abortWindowSizeOutOfRange.
   */
  public static final BBacnetErrorCode abortWindowSizeOutOfRange = new BBacnetErrorCode(ABORT_WINDOW_SIZE_OUT_OF_RANGE);
  /**
   * BBacnetErrorCode constant for fileFull.
   */
  public static final BBacnetErrorCode fileFull = new BBacnetErrorCode(FILE_FULL);
  /**
   * BBacnetErrorCode constant for inconsistentConfiguration.
   */
  public static final BBacnetErrorCode inconsistentConfiguration = new BBacnetErrorCode(INCONSISTENT_CONFIGURATION);
  /**
   * BBacnetErrorCode constant for inconsistentObjectType.
   */
  public static final BBacnetErrorCode inconsistentObjectType = new BBacnetErrorCode(INCONSISTENT_OBJECT_TYPE);
  /**
   * BBacnetErrorCode constant for internalError.
   */
  public static final BBacnetErrorCode internalError = new BBacnetErrorCode(INTERNAL_ERROR);
  /**
   * BBacnetErrorCode constant for notConfigured.
   */
  public static final BBacnetErrorCode notConfigured = new BBacnetErrorCode(NOT_CONFIGURED);
  /**
   * BBacnetErrorCode constant for outOfMemory.
   */
  public static final BBacnetErrorCode outOfMemory = new BBacnetErrorCode(OUT_OF_MEMORY);
  /**
   * BBacnetErrorCode constant for valueTooLong.
   */
  public static final BBacnetErrorCode valueTooLong = new BBacnetErrorCode(VALUE_TOO_LONG);
  /**
   * BBacnetErrorCode constant for abortInsufficientSecurity.
   */
  public static final BBacnetErrorCode abortInsufficientSecurity = new BBacnetErrorCode(ABORT_INSUFFICIENT_SECURITY);
  /**
   * BBacnetErrorCode constant for abortSecurityError.
   */
  public static final BBacnetErrorCode abortSecurityError = new BBacnetErrorCode(ABORT_SECURITY_ERROR);
  /**
   * BBacnetErrorCode constant for nullValueEvent.
   */
  public static final BBacnetErrorCode nullValueEvent = new BBacnetErrorCode(NULL_VALUE_EVENT);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetErrorCode.class);

  /**
   * Factory method with ordinal.
   */
  public static BBacnetErrorCode make(int ordinal)
  {
    return (BBacnetErrorCode)other.getRange().get(ordinal, false);
  }

  /**
   * Factory method with tag.
   */
  public static BBacnetErrorCode make(String tag)
  {
    return (BBacnetErrorCode)other.getRange().get(tag);
  }

  /**
   * Private constructor.
   */
  private BBacnetErrorCode(int ordinal)
  {
    super(ordinal);
  }

  public static final BBacnetErrorCode DEFAULT = other;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////


  public static final int MAX_ASHRAE_ID = ABORT_SECURITY_ERROR;
  public static final int MAX_RESERVED_ID = 255;
  public static final int MAX_ID = 65535;


////////////////////////////////////////////////////////////////
// Niagara extensions
////////////////////////////////////////////////////////////////

  // Error Class - DEVICE

  // Error Class - OBJECT
  /**
   * Ordinal value for targetNotConfigured.
   */
  public static final int TARGET_NOT_CONFIGURED = 1000;
  /**
   * Ordinal value for invalidTargetType.
   */
  public static final int INVALID_TARGET_TYPE = 1001;

  // Error Class - PROPERTY
  // Error Class - RESOURCES
  // Error Class - SECURITY
  // Error Class - SERVICES

  /**
   * BBacnetErrorCode constant for targetNotConfigured.
   */
  public static final String TARGET_NOT_CONFIGURED_TAG = "targetNotConfigured";
  /**
   * BBacnetErrorCode constant for invalidTargetType.
   */
  public static final String INVALID_TARGET_TYPE_TAG = "invalidTargetType";
  public static final int[] NIAGARA_CODES = new int[]
    {
      TARGET_NOT_CONFIGURED,
      INVALID_TARGET_TYPE
    };
  public static final String[] NIAGARA_TAGS = new String[]
    {
      TARGET_NOT_CONFIGURED_TAG,
      INVALID_TARGET_TYPE_TAG
    };

  public static final BEnumRange NIAGARA_ERROR_CODES_RANGE
    = BEnumRange.make(TYPE, NIAGARA_CODES, NIAGARA_TAGS);


////////////////////////////////////////////////////////////////
// Static methods
////////////////////////////////////////////////////////////////

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    return tag(id, null);
  }

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id, BExtensibleEnumList list)
  {
    if (DEFAULT.getRange().isOrdinal(id))
      return DEFAULT.getRange().getTag(id);
    if (isAshrae(id))
      return ASHRAE_PREFIX + id;
    if (isProprietary(id))
    {
      if (list != null)
      {
        if (list.getErrorCodeRange().isOrdinal(id))
          return list.getErrorCodeRange().getTag(id);
      }
      return PROPRIETARY_PREFIX + id;
    }
    throw new InvalidEnumException(id);
  }

  /**
   * Get the ordinal for the given tag.
   *
   * @return the ordinal for the tag, if it is known,
   * or generate one if the tag uses standard prefixes.
   */
  public static int ordinal(String tag)
  {
    return ordinal(tag, null);
  }

  /**
   * Get the ordinal for the given tag.
   *
   * @return the ordinal for the tag, if it is known,
   * or generate one if the tag uses standard prefixes.
   */
  public static int ordinal(String tag, BExtensibleEnumList list)
  {
    if (DEFAULT.getRange().isTag(tag))
      return DEFAULT.getRange().tagToOrdinal(tag);
    if (tag.startsWith(ASHRAE_PREFIX))
      return Integer.parseInt(tag.substring(ASHRAE_PREFIX_LENGTH));
    if (list != null)
    {
      if (list.getErrorCodeRange().isTag(tag))
        return list.getErrorCodeRange().tagToOrdinal(tag);
    }
    if (tag.startsWith(PROPRIETARY_PREFIX))
      return Integer.parseInt(tag.substring(PROPRIETARY_PREFIX_LENGTH));
    throw new InvalidEnumException(tag);
  }

  /**
   * Is this a proprietary extension?
   *
   * @return true if this is a proprietary extension.
   */
  public static boolean isProprietary(int id)
  {
    return (id > MAX_RESERVED_ID) && (id <= MAX_ID);
  }

  /**
   * Is this an ASHRAE extension?
   *
   * @return true if this is an ASHRAE extension.
   */
  public static boolean isAshrae(int id)
  {
    return (id > MAX_ASHRAE_ID) && (id <= MAX_RESERVED_ID);
  }

  /**
   * Is this id valid for this enumeration?
   *
   * @return true if this id is within the allowed range.
   */
  public static boolean isValid(int id)
  {
    return id <= MAX_ID;
  }

  /**
   * Is this id part of the predefined (fixed) range?
   *
   * @return true if this id is in the fixed range.
   */
  public static boolean isFixed(int id)
  {
    return id <= MAX_ASHRAE_ID;
  }
}

