/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.sys.*;

import javax.baja.bacnet.BacnetConst;

/**
 * BBacnetCommControl represents the communication control enumeration
 * defined in the DeviceCommunicationControl-Request definition.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 05 Nov 02
 * @since Niagara 3 Bacnet 1.0
 */
public final class BBacnetCommControl
  extends BFrozenEnum
{
  /*-
  enum BBacnetCommControl
  {
    range
    {
      enable,
      disable,
      disableInitiation
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.enums.BBacnetCommControl(954185902)1.0$ @*/
/* Generated Thu Apr 01 15:19:44 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

  /**
   * Ordinal value for enable.
   */
  public static final int ENABLE = 0;
  /**
   * Ordinal value for disable.
   */
  public static final int DISABLE = 1;
  /**
   * Ordinal value for disableInitiation.
   */
  public static final int DISABLE_INITIATION = 2;

  /**
   * BBacnetCommControl constant for enable.
   */
  public static final BBacnetCommControl enable = new BBacnetCommControl(ENABLE);
  /**
   * BBacnetCommControl constant for disable.
   */
  public static final BBacnetCommControl disable = new BBacnetCommControl(DISABLE);
  /**
   * BBacnetCommControl constant for disableInitiation.
   */
  public static final BBacnetCommControl disableInitiation = new BBacnetCommControl(DISABLE_INITIATION);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetCommControl.class);

  /**
   * Factory method with ordinal.
   */
  public static BBacnetCommControl make(int ordinal)
  {
    return (BBacnetCommControl)enable.getRange().get(ordinal);
  }

  /**
   * Factory method with tag.
   */
  public static BBacnetCommControl make(String tag)
  {
    return (BBacnetCommControl)enable.getRange().get(tag);
  }

  /**
   * Private constructor.
   */
  private BBacnetCommControl(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Static methods
////////////////////////////////////////////////////////////////

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    return DEFAULT.getRange().getTag(id);
  }

  /**
   * @param value the boolean value to be represented.
   * @returns a BBacnetCommControl object with the given code.
  public static final BBacnetCommControl make(boolean value)
  {
  return (value ? enable : disable);
  }
   */

  /**
   * @return String representation of this BEnum.
   */
  public String toString(Context context)
  {
    if ((context != null) && context.equals(BacnetConst.facetsContext))
      return getTag();
    return getDisplayTag(context);
  }


////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  public static final BBacnetCommControl DEFAULT = enable;
}
