/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.enums;

import javax.baja.sys.*;

import javax.baja.bacnet.BacnetConst;

/**
 * BBacnetAction represents the BACnetAction enumeration.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 26 Jul 2005
 * @since Niagara 3.1
 */
public final class BBacnetAction
  extends BFrozenEnum
{
  /*-
  enum BBacnetAction
  {
    range
    {
      direct,
      reverse
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.enums.BBacnetAction(3093848619)1.0$ @*/
/* Generated Tue Jul 26 13:43:33 EDT 2005 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

  /**
   * Ordinal value for direct.
   */
  public static final int DIRECT = 0;
  /**
   * Ordinal value for reverse.
   */
  public static final int REVERSE = 1;

  /**
   * BBacnetAction constant for direct.
   */
  public static final BBacnetAction direct = new BBacnetAction(DIRECT);
  /**
   * BBacnetAction constant for reverse.
   */
  public static final BBacnetAction reverse = new BBacnetAction(REVERSE);

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetAction.class);

  /**
   * Factory method with ordinal.
   */
  public static BBacnetAction make(int ordinal)
  {
    return (BBacnetAction)direct.getRange().get(ordinal, false);
  }

  /**
   * Factory method with tag.
   */
  public static BBacnetAction make(String tag)
  {
    return (BBacnetAction)direct.getRange().get(tag);
  }

  /**
   * Private constructor.
   */
  private BBacnetAction(int ordinal)
  {
    super(ordinal);
  }

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Static methods
////////////////////////////////////////////////////////////////

  /**
   * Create a string tag for the given ordinal.
   *
   * @return the tag for the ordinal, if it is known,
   * or construct one using standard prefixes.
   */
  public static String tag(int id)
  {
    return DEFAULT.getRange().getTag(id);
  }

  /**
   * Get a string tag, using the true/false text in the
   * given context, if possible.
   */
  public String getTag(Context cx)
  {
    if (cx != null)
    {
      BString tag = (BString)cx.getFacet(isActive() ? BFacets.TRUE_TEXT : BFacets.FALSE_TEXT);
      return (tag != null) ? tag.getString() : getTag();
    }
    return getTag();
  }

  /**
   * @param value the boolean value to be represented.
   * @returns a BBacnetAction object with the given code.
   */
  public static final BBacnetAction make(boolean value)
  {
    return (value ? reverse : direct);
  }

  /**
   * @return String representation of this BEnum.
   */
  public String toString(Context context)
  {
    if ((context != null) && context.equals(BacnetConst.facetsContext))
      return getTag();
    return getDisplayTag(context);
  }


////////////////////////////////////////////////////////////////
// Constants
////////////////////////////////////////////////////////////////

  public static final BBacnetAction DEFAULT = direct;
}
