/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.sys.*;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;

/**
 * BBacnetDateTime represents a BacnetDateTime value in a Bacnet property.
 *
 * @author Craig Gemmill
 * @version $Revision: 3$ $Date: 11/6/01 2:50:13 PM$
 * @creation 09 Aug 01
 * @since Niagara 3 Bacnet 1.0
 */

public class BBacnetDateTime
  extends BStruct
  implements BIBacnetDataType,
  Comparable<Object>
{
  /*-
  class BBacnetDateTime
  {
    properties
    {
      date: BBacnetDate
        default {[ BBacnetDate.DEFAULT ]}
      time: BBacnetTime
        default {[ BBacnetTime.DEFAULT ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.datatypes.BBacnetDateTime(961452736)1.0$ @*/
/* Generated Fri Sep 15 09:15:27 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "date"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>date</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetDateTime#getDate
   * @see javax.baja.bacnet.datatypes.BBacnetDateTime#setDate
   */
  public static final Property date = newProperty(0, BBacnetDate.DEFAULT, null);

  /**
   * Get the <code>date</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetDateTime#date
   */
  public BBacnetDate getDate()
  {
    return (BBacnetDate)get(date);
  }

  /**
   * Set the <code>date</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetDateTime#date
   */
  public void setDate(BBacnetDate v)
  {
    set(date, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "time"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>time</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetDateTime#getTime
   * @see javax.baja.bacnet.datatypes.BBacnetDateTime#setTime
   */
  public static final Property time = newProperty(0, BBacnetTime.DEFAULT, null);

  /**
   * Get the <code>time</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetDateTime#time
   */
  public BBacnetTime getTime()
  {
    return (BBacnetTime)get(time);
  }

  /**
   * Set the <code>time</code> property.
   *
   * @see javax.baja.bacnet.datatypes.BBacnetDateTime#time
   */
  public void setTime(BBacnetTime v)
  {
    set(time, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetDateTime.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Constructor
////////////////////////////////////////////////////////////////

  public BBacnetDateTime()
  {
  }

  public BBacnetDateTime(BBacnetDate date, BBacnetTime time)
  {
    setDate(date);
    setTime(time);
  }

  public BBacnetDateTime(BAbsTime bt)
  {
    setDate(BBacnetDate.make(bt));
    setTime(BBacnetTime.make(bt));
  }


////////////////////////////////////////////////////////////////
//  BIBacnetDataType
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  public final void writeAsn(AsnOutput out)
  {
    out.writeDate(getDate());
    out.writeTime(getTime());
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  public final void readAsn(AsnInput in)
    throws AsnException
  {
    set(date, in.readDate(), noWrite);
    set(time, in.readTime(), noWrite);
  }


////////////////////////////////////////////////////////////////
//  Access
////////////////////////////////////////////////////////////////

  /**
   * To String.
   */
  public String toString(Context context)
  {
    if ((context != null) && context.equals(BacnetConst.facetsContext))
      return getDate().toString(context, false) + ' ' + getTime().toString(context);
    else
      return getDate().toString(context) + '_' + getTime().toString(context);
  }

  /**
   * Is any field in either the date or the time UNPSECIFIED?
   *
   * @returns true if any field in either the date or the time in unspecified.
   */
  public final boolean isAnyUnspecified()
  {
    return getDate().isAnyUnspecified() || getTime().isAnyUnspecified();
  }

  /**
   * Return a BAbsTime from this BacnetDateTime object.
   * No needed fields may be UNPSECIFIED.
   *
   * @throws IllegalStateException if any field is UNSPECIFIED.
   * @returns a BAbsTime representing the same absolute time.
   */
  public final BAbsTime toBAbsTime()
  {
    return makeBAbsTime(getDate(), getTime());
  }

  /**
   * Set this BBacnetDateTime from the given BAbsTime.
   *
   * @param t the BAbsTime.
   */
  public final void fromBAbsTime(BAbsTime t)
  {
    setDate(BBacnetDate.make(t));
    setTime(BBacnetTime.make(t));
  }


////////////////////////////////////////////////////////////////
// Comparison
////////////////////////////////////////////////////////////////

  /**
   * BBacnetDateTime equivalence is based on all values being equal,
   * or unspecified.
   * <B>NOTE</B>: This is the method to determine DateTime equivalence according
   * to BACnet, <B>not</B> the equals() method, which requires UNSPECIFIED values
   * to match <B>only</B> with UNSPECIFIED values.
   *
   * @param obj the comparison object.
   * @see equals
   */
  public final boolean dateTimeEquals(Object obj)
  {
    return compareTo(obj) == 0;
  }

  /**
   * Compare to another BBacnetDate.
   *
   * @param obj the comparison object.
   * @returns a negative integer, zero, or a
   * positive integer as this object is less
   * than, equal to, or greater than the
   * specified object.
   */
  public final int compareTo(Object obj)
  {
    if (obj == null) throw new ClassCastException();
    BBacnetDateTime other = (BBacnetDateTime)obj;

    // Check date first.
    int ret = getDate().compareTo(other.getDate());
    if (ret != 0)
      return ret;

    return getTime().compareTo(other.getTime());
  }

  /**
   * @return true if the specified date is before this date.
   */
  public final boolean isBefore(Object x)
  {
    return compareTo(x) < 0;
  }

  /**
   * @return true if the specified date is after this date.
   */
  public final boolean isAfter(Object x)
  {
    return compareTo(x) > 0;
  }

  /**
   * @return true if the specified date is not before this date.
   */
  public final boolean isNotBefore(Object x)
  {
    return compareTo(x) >= 0;
  }

  /**
   * @return true if the specified date is not after this date.
   */
  public final boolean isNotAfter(Object x)
  {
    return compareTo(x) <= 0;
  }


////////////////////////////////////////////////////////////////
//  Utility
////////////////////////////////////////////////////////////////

  /**
   * Read the date and time values from the
   * given String and return a new BBacnetDateTime.
   *
   * @param s the input string.
   * @return a BBacnetDateTime read from the string.
   */
  public static final BBacnetDateTime fromString(String s)
  {
    BBacnetDate d = BBacnetDate.fromString(s.substring(0, BBacnetDate.TEXT_LENGTH));
    BBacnetTime t = BBacnetTime.fromString(s.substring(BBacnetDate.TEXT_LENGTH + 1,
      BBacnetDate.TEXT_LENGTH + 1 + BBacnetTime.TEXT_LENGTH));
    return new BBacnetDateTime(d, t);
  }

  /**
   * Return a BAbsTime from the given BBacnetDate and BBacnetTime.
   *
   * @param d date
   * @param t time
   * @returns a BAbsTime representing the same absolute time.
   */
  public static final BAbsTime makeBAbsTime(BBacnetDate d, BBacnetTime t)
  {
    int y = d.isYearUnspecified() ? 1900 : d.getYear();
    BMonth m = d.isMonthUnspecified() ? BMonth.january : d.getBMonth();
    int a = d.isDayOfMonthUnspecified() ? 1 : d.getDayOfMonth();
    int h = t.isHourUnspecified() ? 0 : t.getHour();
    int n = t.isMinuteUnspecified() ? 0 : t.getMinute();
    if (t.isSecondUnspecified() || t.isHundredthUnspecified())
      return BAbsTime.make(y, m, a, h, n);
    else
      return BAbsTime.make(y, m, a, h, n, t.getSecond(), t.getHundredth() * 10);
  }

  /**
   * Return a BAbsTime from the given BBacnetDate and BBacnetTime.
   *
   * @param d date
   * @param t time
   * @returns a BAbsTime representing the same absolute time.
   */
  public static final BAbsTime makeBAbsTime(BAbsTime d, BBacnetTime t)
  {
    int h = t.isHourUnspecified() ? 0 : t.getHour();
    int n = t.isMinuteUnspecified() ? 0 : t.getMinute();

    if (t.isSecondUnspecified() || t.isHundredthUnspecified())
      return BAbsTime.make(d.getYear(), d.getMonth(), d.getDay(), h, n);
    else
      return BAbsTime.make(d.getYear(), d.getMonth(), d.getDay(),
        t.getHour(), t.getMinute(), t.getSecond(), t.getHundredth() * 10);
  }
}