/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import com.tridium.bacnet.BacUtil;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.NBacnetPropertyValue;
import com.tridium.bacnet.stack.BBacnetStack;

import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.datatypes.BBacnetDeviceObjectPropertyReference;
import javax.baja.bacnet.datatypes.BBacnetPropertyValue;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.*;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;
/**
 * @author    Craig Gemmill
 * @creation  30 Jan 01
 * @version   $Revision: 7$ $Date: 12/10/01 9:26:02 AM$
 * @since     Niagara 3 Bacnet 1.0
 */
public class BBacnetTrendLog extends BBacnetCreatableObject
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.TREND_LOG),
      makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
        ASN_OBJECT_IDENTIFIER) );

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.TREND_LOG,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED) );

  /*-

  class BBacnetTrendLog
  {
    properties
    {
      logEnable: boolean
        default {[ false ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.ENABLE,
                                 ASN_BOOLEAN) ]}
      stopWhenFull: boolean
        default {[ false ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.STOP_WHEN_FULL,
                                 ASN_BOOLEAN) ]}
      bufferSize: BBacnetUnsigned
        default {[ BBacnetUnsigned.make(60) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.BUFFER_SIZE,
                                 ASN_UNSIGNED) ]}
      recordCount: BBacnetUnsigned
        default {[ BBacnetUnsigned.make(0) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.RECORD_COUNT,
                                 ASN_UNSIGNED) ]}
      totalRecordCount: BBacnetUnsigned
        default {[ BBacnetUnsigned.make(0) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.TOTAL_RECORD_COUNT,
                                 ASN_UNSIGNED) ]}
      notifyType: BBacnetNotifyType
        -- eventState indicates if this object has an active event state.
        default {[ BBacnetNotifyType.event ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.NOTIFY_TYPE,
                ASN_ENUMERATED),
                BFacets.make(BacUtil.makeBacnetNotifyTypeFacets()) ]}
      notificationClass: BBacnetUnsigned
        -- references a Notification Class in the same device that specifies the
        -- handling, reporting, and acknowledgment characteristics for this object.
        default {[ BBacnetUnsigned.make(BBacnetObjectIdentifier.UNCONFIGURED_INSTANCE_NUMBER) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.NOTIFICATION_CLASS,
                                 ASN_UNSIGNED,
                                 new String[] { BFacets.MIN, BFacets.MAX },
                                 new BInteger[] { BInteger.make(1), BInteger.make(BBacnetObjectIdentifier.MAX_INSTANCE_NUMBER) } ) ]}
      objectPropertyReference: BBacnetDeviceObjectPropertyReference
        default {[ new BBacnetDeviceObjectPropertyReference() ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.LOG_DEVICE_OBJECT_PROPERTY,
                                 ASN_CONSTRUCTED_DATA) ]}
      eventState: BEnum
        -- eventState indicates if this object has an active event state.
        flags { readonly }
        default {[ BDynamicEnum.make(BBacnetEventState.NORMAL,
                                     BEnumRange.make(BBacnetEventState.TYPE)) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.EVENT_STATE,
                                 ASN_ENUMERATED) ]}
    }

    actions
    {
    }
  }

  -*/



/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetTrendLog(1526713308)1.0$ @*/
/* Generated Thu May 30 15:11:37 IST 2019 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "logEnable"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code logEnable} property.
   * @see #getLogEnable
   * @see #setLogEnable
   */
  public static final Property logEnable = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.ENABLE,
                                 ASN_BOOLEAN));
  
  /**
   * Get the {@code logEnable} property.
   * @see #logEnable
   */
  public boolean getLogEnable() { return getBoolean(logEnable); }
  
  /**
   * Set the {@code logEnable} property.
   * @see #logEnable
   */
  public void setLogEnable(boolean v) { setBoolean(logEnable, v, null); }

////////////////////////////////////////////////////////////////
// Property "stopWhenFull"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code stopWhenFull} property.
   * @see #getStopWhenFull
   * @see #setStopWhenFull
   */
  public static final Property stopWhenFull = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.STOP_WHEN_FULL,
                                 ASN_BOOLEAN));
  
  /**
   * Get the {@code stopWhenFull} property.
   * @see #stopWhenFull
   */
  public boolean getStopWhenFull() { return getBoolean(stopWhenFull); }
  
  /**
   * Set the {@code stopWhenFull} property.
   * @see #stopWhenFull
   */
  public void setStopWhenFull(boolean v) { setBoolean(stopWhenFull, v, null); }

////////////////////////////////////////////////////////////////
// Property "bufferSize"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code bufferSize} property.
   * @see #getBufferSize
   * @see #setBufferSize
   */
  public static final Property bufferSize = newProperty(0, BBacnetUnsigned.make(60), makeFacets(BBacnetPropertyIdentifier.BUFFER_SIZE,
                                 ASN_UNSIGNED));
  
  /**
   * Get the {@code bufferSize} property.
   * @see #bufferSize
   */
  public BBacnetUnsigned getBufferSize() { return (BBacnetUnsigned)get(bufferSize); }
  
  /**
   * Set the {@code bufferSize} property.
   * @see #bufferSize
   */
  public void setBufferSize(BBacnetUnsigned v) { set(bufferSize, v, null); }

////////////////////////////////////////////////////////////////
// Property "recordCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code recordCount} property.
   * @see #getRecordCount
   * @see #setRecordCount
   */
  public static final Property recordCount = newProperty(0, BBacnetUnsigned.make(0), makeFacets(BBacnetPropertyIdentifier.RECORD_COUNT,
                                 ASN_UNSIGNED));
  
  /**
   * Get the {@code recordCount} property.
   * @see #recordCount
   */
  public BBacnetUnsigned getRecordCount() { return (BBacnetUnsigned)get(recordCount); }
  
  /**
   * Set the {@code recordCount} property.
   * @see #recordCount
   */
  public void setRecordCount(BBacnetUnsigned v) { set(recordCount, v, null); }

////////////////////////////////////////////////////////////////
// Property "totalRecordCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code totalRecordCount} property.
   * @see #getTotalRecordCount
   * @see #setTotalRecordCount
   */
  public static final Property totalRecordCount = newProperty(0, BBacnetUnsigned.make(0), makeFacets(BBacnetPropertyIdentifier.TOTAL_RECORD_COUNT,
                                 ASN_UNSIGNED));
  
  /**
   * Get the {@code totalRecordCount} property.
   * @see #totalRecordCount
   */
  public BBacnetUnsigned getTotalRecordCount() { return (BBacnetUnsigned)get(totalRecordCount); }
  
  /**
   * Set the {@code totalRecordCount} property.
   * @see #totalRecordCount
   */
  public void setTotalRecordCount(BBacnetUnsigned v) { set(totalRecordCount, v, null); }

////////////////////////////////////////////////////////////////
// Property "notifyType"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code notifyType} property.
   * eventState indicates if this object has an active event state.
   * @see #getNotifyType
   * @see #setNotifyType
   */
  public static final Property notifyType = newProperty(0, BBacnetNotifyType.event, BFacets.make(makeFacets(BBacnetPropertyIdentifier.NOTIFY_TYPE,
                ASN_ENUMERATED), BFacets.make(BacUtil.makeBacnetNotifyTypeFacets())));
  
  /**
   * Get the {@code notifyType} property.
   * eventState indicates if this object has an active event state.
   * @see #notifyType
   */
  public BBacnetNotifyType getNotifyType() { return (BBacnetNotifyType)get(notifyType); }
  
  /**
   * Set the {@code notifyType} property.
   * eventState indicates if this object has an active event state.
   * @see #notifyType
   */
  public void setNotifyType(BBacnetNotifyType v) { set(notifyType, v, null); }

////////////////////////////////////////////////////////////////
// Property "notificationClass"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code notificationClass} property.
   * references a Notification Class in the same device that specifies the
   * handling, reporting, and acknowledgment characteristics for this object.
   * @see #getNotificationClass
   * @see #setNotificationClass
   */
  public static final Property notificationClass = newProperty(0, BBacnetUnsigned.make(BBacnetObjectIdentifier.UNCONFIGURED_INSTANCE_NUMBER), makeFacets(BBacnetPropertyIdentifier.NOTIFICATION_CLASS,
                                 ASN_UNSIGNED,
                                 new String[] { BFacets.MIN, BFacets.MAX },
                                 new BInteger[] { BInteger.make(1), BInteger.make(BBacnetObjectIdentifier.MAX_INSTANCE_NUMBER) } ));
  
  /**
   * Get the {@code notificationClass} property.
   * references a Notification Class in the same device that specifies the
   * handling, reporting, and acknowledgment characteristics for this object.
   * @see #notificationClass
   */
  public BBacnetUnsigned getNotificationClass() { return (BBacnetUnsigned)get(notificationClass); }
  
  /**
   * Set the {@code notificationClass} property.
   * references a Notification Class in the same device that specifies the
   * handling, reporting, and acknowledgment characteristics for this object.
   * @see #notificationClass
   */
  public void setNotificationClass(BBacnetUnsigned v) { set(notificationClass, v, null); }

////////////////////////////////////////////////////////////////
// Property "objectPropertyReference"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code objectPropertyReference} property.
   * @see #getObjectPropertyReference
   * @see #setObjectPropertyReference
   */
  public static final Property objectPropertyReference = newProperty(0, new BBacnetDeviceObjectPropertyReference(), makeFacets(BBacnetPropertyIdentifier.LOG_DEVICE_OBJECT_PROPERTY,
                                 ASN_CONSTRUCTED_DATA));
  
  /**
   * Get the {@code objectPropertyReference} property.
   * @see #objectPropertyReference
   */
  public BBacnetDeviceObjectPropertyReference getObjectPropertyReference() { return (BBacnetDeviceObjectPropertyReference)get(objectPropertyReference); }
  
  /**
   * Set the {@code objectPropertyReference} property.
   * @see #objectPropertyReference
   */
  public void setObjectPropertyReference(BBacnetDeviceObjectPropertyReference v) { set(objectPropertyReference, v, null); }

////////////////////////////////////////////////////////////////
// Property "eventState"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code eventState} property.
   * eventState indicates if this object has an active event state.
   * @see #getEventState
   * @see #setEventState
   */
  public static final Property eventState = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetEventState.NORMAL,
                                     BEnumRange.make(BBacnetEventState.TYPE)), makeFacets(BBacnetPropertyIdentifier.EVENT_STATE,
                                 ASN_ENUMERATED));
  
  /**
   * Get the {@code eventState} property.
   * eventState indicates if this object has an active event state.
   * @see #eventState
   */
  public BEnum getEventState() { return (BEnum)get(eventState); }
  
  /**
   * Set the {@code eventState} property.
   * eventState indicates if this object has an active event state.
   * @see #eventState
   */
  public void setEventState(BEnum v) { set(eventState, v, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBacnetTrendLog.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  private static final Lexicon lex = Lexicon.make("bacnet");

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BBacnetTrendLog() {}


////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Should this property ID be polled?
   * Override point for objects to filter properties for polling, e.g.,
   * Object_List in Device object, or Log_Buffer in Trend Log.
   */
  protected boolean shouldPoll(int propertyId)
  {
    switch (propertyId)
    {
      case BBacnetPropertyIdentifier.LOG_BUFFER:
        return false;
    }
    return true;
  }

  /**
   * This code was added to fix a UI issue raised by BTL.
   * The issue is articulated in the Jira entry NCCB-29907.
   */
  @Override
  public String getDisplayName(Slot slot, Context cx)
  {
    if(slot == logEnable)
      return lex.getText("bacnet.trendlog.log.enable.display.name");
    if(slot == totalRecordCount)
      return lex.getText("bacnet.trendlog.log.buffer.display.name");
     return super.getDisplayName(slot, cx);
  }
////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  Attributes
////////////////////////////////////////////////////////////////

  @Override
  protected void addObjectInitialValues(Array<PropertyValue> listOfInitialValues)
  {
    addNotifyType(getNotifyType(), listOfInitialValues);
    addLogDeviceObjectPropertyReference(getObjectPropertyReference(), listOfInitialValues);
    addNotificationClass(getNotificationClass(), listOfInitialValues);
  }
}
