/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.sys.*;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.*;
import javax.baja.bacnet.util.BacnetBitStringUtil;

/**
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 17 Oct 2005
 * @since Niagara 3.1
 */
public class BBacnetProgram
  extends BBacnetObject
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.PROGRAM),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.PROGRAM,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

  /*-

  class BBacnetProgram
  {
    properties
    {
      programState: BBacnetProgramState
        flags { transient, readonly }
        default {[ BBacnetProgramState.idle ]}
          slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PROGRAM_STATE,
                                   ASN_ENUMERATED) ]}

      programChange: BBacnetProgramRequest
        default {[ BBacnetProgramRequest.ready ]}
          slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PROGRAM_CHANGE,
                                   ASN_ENUMERATED) ]}

      statusFlags: BBacnetBitString
        flags { readonly }
        default {[ BBacnetBitString.emptyBitString(
                   BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS,
                                 ASN_BIT_STRING,
                                 BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP) ]}

      outOfService: boolean
        -- is the physical point represented by this object out of service?
        -- if TRUE, then this point's Present_Value does NOT reflect the actual state
        -- of the point.
        default {[ false ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE,
                                 ASN_BOOLEAN) ]}
    }

    actions
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetProgram(1710011748)1.0$ @*/
/* Generated Wed May 24 10:51:25 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "programState"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>programState</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetProgram#getProgramState
   * @see javax.baja.bacnet.config.BBacnetProgram#setProgramState
   */
  public static final Property programState = newProperty(Flags.TRANSIENT | Flags.READONLY, BBacnetProgramState.idle, makeFacets(BBacnetPropertyIdentifier.PROGRAM_STATE,
    ASN_ENUMERATED));

  /**
   * Get the <code>programState</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetProgram#programState
   */
  public BBacnetProgramState getProgramState()
  {
    return (BBacnetProgramState)get(programState);
  }

  /**
   * Set the <code>programState</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetProgram#programState
   */
  public void setProgramState(BBacnetProgramState v)
  {
    set(programState, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "programChange"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>programChange</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetProgram#getProgramChange
   * @see javax.baja.bacnet.config.BBacnetProgram#setProgramChange
   */
  public static final Property programChange = newProperty(0, BBacnetProgramRequest.ready, makeFacets(BBacnetPropertyIdentifier.PROGRAM_CHANGE,
    ASN_ENUMERATED));

  /**
   * Get the <code>programChange</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetProgram#programChange
   */
  public BBacnetProgramRequest getProgramChange()
  {
    return (BBacnetProgramRequest)get(programChange);
  }

  /**
   * Set the <code>programChange</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetProgram#programChange
   */
  public void setProgramChange(BBacnetProgramRequest v)
  {
    set(programChange, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "statusFlags"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>statusFlags</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetProgram#getStatusFlags
   * @see javax.baja.bacnet.config.BBacnetProgram#setStatusFlags
   */
  public static final Property statusFlags = newProperty(Flags.READONLY, BBacnetBitString.emptyBitString(
    BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS,
    ASN_BIT_STRING,
    BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));

  /**
   * Get the <code>statusFlags</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetProgram#statusFlags
   */
  public BBacnetBitString getStatusFlags()
  {
    return (BBacnetBitString)get(statusFlags);
  }

  /**
   * Set the <code>statusFlags</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetProgram#statusFlags
   */
  public void setStatusFlags(BBacnetBitString v)
  {
    set(statusFlags, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "outOfService"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>outOfService</code> property.
   * is the physical point represented by this object out
   * of service? if TRUE, then this point's Present_Value
   * does NOT reflect the actual state of the point.
   *
   * @see javax.baja.bacnet.config.BBacnetProgram#getOutOfService
   * @see javax.baja.bacnet.config.BBacnetProgram#setOutOfService
   */
  public static final Property outOfService = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE,
    ASN_BOOLEAN));

  /**
   * Get the <code>outOfService</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetProgram#outOfService
   */
  public boolean getOutOfService()
  {
    return getBoolean(outOfService);
  }

  /**
   * Set the <code>outOfService</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetProgram#outOfService
   */
  public void setOutOfService(boolean v)
  {
    setBoolean(outOfService, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetProgram.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BBacnetProgram()
  {
  }


////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  public String toString(Context context)
  {
    StringBuilder sb = new StringBuilder();
    sb.append(getObjectId().toString(context))
      .append(nameContext.equals(context) ? '_' : ':');
    return sb.toString();
  }


////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  BComponent
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
//  Overrides
////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  Attributes
////////////////////////////////////////////////////////////////

}
