/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.nre.util.Array;
import javax.baja.sys.*;
import javax.baja.driver.loadable.BUploadParameters;
import javax.baja.bacnet.datatypes.*;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.bacnet.util.BacnetBitStringUtil;

import com.tridium.bacnet.datatypes.BNcRecipientList;



/**
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 24 Jun 02
 * @since Niagara 3 Bacnet 1.0
 */
public class BBacnetNotificationClass
  extends BBacnetCreatableObject
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.NOTIFICATION_CLASS),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.NOTIFICATION_CLASS,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

  /*-

  class BBacnetNotificationClass
  {
    properties
    {
      notificationClass: BBacnetUnsigned
        flags { readonly }
        default {[ BBacnetUnsigned.DEFAULT ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.NOTIFICATION_CLASS,
                                 ASN_UNSIGNED) ]}
      priority: BBacnetArray
        flags { readonly }
        default {[ new BBacnetArray(BBacnetUnsigned.TYPE, 3) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PRIORITY,
                                 ASN_BACNET_ARRAY) ]}
      ackRequired: BBacnetBitString
//        flags { readonly }
        default {[ BBacnetBitString.emptyBitString(
                   BacnetBitStringUtil.getBitStringLength("BacnetEventTransitionBits")) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.ACK_REQUIRED,
                                 ASN_BIT_STRING,
                                 BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_MAP) ]}
      recipientList: BBacnetListOf
//        flags { readonly }
        default {[ new BNcRecipientList(BBacnetDestination.TYPE) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.RECIPIENT_LIST,
                                 ASN_BACNET_LIST) ]}
    }

    actions
    {
      addDestination(dest:BBacnetDestination)
        -- add a destination to the notification class's recipient list.
        default {[ new BBacnetDestination() ]}
      removeDestination(dest:BBacnetDestination)
        -- remove a destination from the notification class's recipient list.
        default {[ new BBacnetDestination() ]}
      removeRecipient(recip:BBacnetRecipient)
        -- remove all destinations with this recipient
        -- from the notification class's recipient list.
        default {[ new BBacnetRecipient() ]}

    }
  }

  -*/

  
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetNotificationClass(1544530899)1.0$ @*/
/* Generated Thu Jun 13 12:37:24 IST 2019 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Property "notificationClass"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code notificationClass} property.
   * @see #getNotificationClass
   * @see #setNotificationClass
   */
  public static final Property notificationClass = newProperty(Flags.READONLY, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.NOTIFICATION_CLASS,
                                 ASN_UNSIGNED));
  
  /**
   * Get the {@code notificationClass} property.
   * @see #notificationClass
   */
  public BBacnetUnsigned getNotificationClass() { return (BBacnetUnsigned)get(notificationClass); }
  
  /**
   * Set the {@code notificationClass} property.
   * @see #notificationClass
   */
  public void setNotificationClass(BBacnetUnsigned v) { set(notificationClass, v, null); }

////////////////////////////////////////////////////////////////
// Property "priority"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code priority} property.
   * @see #getPriority
   * @see #setPriority
   */
  public static final Property priority = newProperty(Flags.READONLY, new BBacnetArray(BBacnetUnsigned.TYPE, 3), makeFacets(BBacnetPropertyIdentifier.PRIORITY,
                                 ASN_BACNET_ARRAY));
  
  /**
   * Get the {@code priority} property.
   * @see #priority
   */
  public BBacnetArray getPriority() { return (BBacnetArray)get(priority); }
  
  /**
   * Set the {@code priority} property.
   * @see #priority
   */
  public void setPriority(BBacnetArray v) { set(priority, v, null); }

////////////////////////////////////////////////////////////////
// Property "ackRequired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code ackRequired} property.
   * @see #getAckRequired
   * @see #setAckRequired
   */
  public static final Property ackRequired = newProperty(0, BBacnetBitString.emptyBitString(
                   BacnetBitStringUtil.getBitStringLength("BacnetEventTransitionBits")), makeFacets(BBacnetPropertyIdentifier.ACK_REQUIRED,
                                 ASN_BIT_STRING,
                                 BacnetBitStringUtil.BACNET_EVENT_TRANSITION_BITS_MAP));
  
  /**
   * Get the {@code ackRequired} property.
   * @see #ackRequired
   */
  public BBacnetBitString getAckRequired() { return (BBacnetBitString)get(ackRequired); }
  
  /**
   * Set the {@code ackRequired} property.
   * @see #ackRequired
   */
  public void setAckRequired(BBacnetBitString v) { set(ackRequired, v, null); }

////////////////////////////////////////////////////////////////
// Property "recipientList"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code recipientList} property.
   * @see #getRecipientList
   * @see #setRecipientList
   */
  public static final Property recipientList = newProperty(0, new BNcRecipientList(BBacnetDestination.TYPE), makeFacets(BBacnetPropertyIdentifier.RECIPIENT_LIST,
                                 ASN_BACNET_LIST));
  
  /**
   * Get the {@code recipientList} property.
   * @see #recipientList
   */
  public BBacnetListOf getRecipientList() { return (BBacnetListOf)get(recipientList); }
  
  /**
   * Set the {@code recipientList} property.
   * @see #recipientList
   */
  public void setRecipientList(BBacnetListOf v) { set(recipientList, v, null); }

////////////////////////////////////////////////////////////////
// Action "addDestination"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code addDestination} action.
   * add a destination to the notification class's recipient list.
   * @see #addDestination(BBacnetDestination dest)
   */
  public static final Action addDestination = newAction(0, new BBacnetDestination(), null);
  
  /**
   * Invoke the {@code addDestination} action.
   * add a destination to the notification class's recipient list.
   * @see #addDestination
   */
  public void addDestination(BBacnetDestination dest) { invoke(addDestination, dest, null); }

////////////////////////////////////////////////////////////////
// Action "removeDestination"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code removeDestination} action.
   * remove a destination from the notification class's recipient list.
   * @see #removeDestination(BBacnetDestination dest)
   */
  public static final Action removeDestination = newAction(0, new BBacnetDestination(), null);
  
  /**
   * Invoke the {@code removeDestination} action.
   * remove a destination from the notification class's recipient list.
   * @see #removeDestination
   */
  public void removeDestination(BBacnetDestination dest) { invoke(removeDestination, dest, null); }

////////////////////////////////////////////////////////////////
// Action "removeRecipient"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the {@code removeRecipient} action.
   * remove all destinations with this recipient
   * from the notification class's recipient list.
   * @see #removeRecipient(BBacnetRecipient recip)
   */
  public static final Action removeRecipient = newAction(0, new BBacnetRecipient(), null);
  
  /**
   * Invoke the {@code removeRecipient} action.
   * remove all destinations with this recipient
   * from the notification class's recipient list.
   * @see #removeRecipient
   */
  public void removeRecipient(BBacnetRecipient recip) { invoke(removeRecipient, recip, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBacnetNotificationClass.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
  /*@ $javax.baja.bacnet.config.BBacnetNotificationClass(2045107987)1.0$ @*/


////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BBacnetNotificationClass()
  {
  }


////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

//  /**
//   * Overridden here to provide the default value for the
//   * Set action.
//   */
//  public BValue getActionParameterDefault(Action action)
//  {
//    if (action == addDestination)
//    {
//      BBacnetDestination dest = new BBacnetDestination();
//      dest.getRecipient().setRecipient(((BBacnetNetwork)getNetwork()).getLocalDevice().getObjectId());
//      dest.setProcessIdentifier(BBacnetUnsigned.make(((BBacnetDevice)getDevice()).getAlarms().getNiagaraProcessId()));
//      return dest;
//    }
//    return super.getActionParameterDefault(action);
//  }


////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////

  /**
   * Add a destination to the recipient list.
   */
  public void doAddDestination(BBacnetDestination dest)
  {
    getRecipientList().addListElement(dest, null);
  }

  /**
   * Remove a destination from the recipient list.
   */
  public void doRemoveDestination(BBacnetDestination dest)
  {
    getRecipientList().removeListElement(dest, null);
  }

  /**
   * Remove all destinations for a particular recipient from the recipient list.
   */
  public void doRemoveRecipient(BBacnetRecipient recip)
  {
    network().postAsync(new NCRemoveRecipientRequest(recip));
    upload(new BUploadParameters());
  }

  //////////////////////////////////////////////////////////////
  //  Inner Class: NCRemoveRecipientRequest
  //////////////////////////////////////////////////////////////
  class NCRemoveRecipientRequest
    implements Runnable
  {
    NCRemoveRecipientRequest(BBacnetRecipient recip)
    {
      this.recip = recip;
    }

    public void run()
    {
      SlotCursor<Property> sc = getRecipientList().getProperties();
      while (sc.next(BBacnetDestination.class))
      {
        BBacnetDestination d = (BBacnetDestination) sc.get();
        if (d.getRecipient().equivalent(recip))
        {
          getRecipientList().removeListElement(d, null);
        }
      }
    }

    public BBacnetRecipient recip;
  }

  //////////////////////////////////////////////////////////////
  //  Overrides
  //////////////////////////////////////////////////////////////
  protected void addObjectInitialValues(Array<PropertyValue> listOfInitialValues)
  {
    addPriority(priority, listOfInitialValues);
    addAckRequired(ackRequired, listOfInitialValues);
    addRecipientist( recipientList, listOfInitialValues);
  }

}
