/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.sys.*;

import javax.baja.bacnet.datatypes.*;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;

/**
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 25 Jun 02
 * @since Niagara 3 Bacnet 1.0
 */
public class BBacnetMultistateOutput
  extends BBacnetMultistate
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.MULTI_STATE_OUTPUT),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.MULTI_STATE_OUTPUT,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

  /*-

  class  BBacnetMultistateOutput
  {
    properties
    {
      priorityArray: BBacnetArray
        default {[ new BBacnetArray(BBacnetPriorityValue.TYPE, 16) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PRIORITY_ARRAY,
                                 ASN_BACNET_ARRAY) ]}
      relinquishDefault: BBacnetUnsigned
        default {[ new BBacnetUnsigned(0) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.RELINQUISH_DEFAULT,
                                 ASN_UNSIGNED) ]}
    }

    actions
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetMultistateOutput(1686638759)1.0$ @*/
/* Generated Fri Apr 02 14:18:14 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "priorityArray"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>priorityArray</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetMultistateOutput#getPriorityArray
   * @see javax.baja.bacnet.config.BBacnetMultistateOutput#setPriorityArray
   */
  public static final Property priorityArray = newProperty(0, new BBacnetArray(BBacnetPriorityValue.TYPE, 16), makeFacets(BBacnetPropertyIdentifier.PRIORITY_ARRAY,
    ASN_BACNET_ARRAY));

  /**
   * Get the <code>priorityArray</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetMultistateOutput#priorityArray
   */
  public BBacnetArray getPriorityArray()
  {
    return (BBacnetArray)get(priorityArray);
  }

  /**
   * Set the <code>priorityArray</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetMultistateOutput#priorityArray
   */
  public void setPriorityArray(BBacnetArray v)
  {
    set(priorityArray, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "relinquishDefault"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>relinquishDefault</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetMultistateOutput#getRelinquishDefault
   * @see javax.baja.bacnet.config.BBacnetMultistateOutput#setRelinquishDefault
   */
  public static final Property relinquishDefault = newProperty(0, new BBacnetUnsigned(0), makeFacets(BBacnetPropertyIdentifier.RELINQUISH_DEFAULT,
    ASN_UNSIGNED));

  /**
   * Get the <code>relinquishDefault</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetMultistateOutput#relinquishDefault
   */
  public BBacnetUnsigned getRelinquishDefault()
  {
    return (BBacnetUnsigned)get(relinquishDefault);
  }

  /**
   * Set the <code>relinquishDefault</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetMultistateOutput#relinquishDefault
   */
  public void setRelinquishDefault(BBacnetUnsigned v)
  {
    set(relinquishDefault, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetMultistateOutput.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   */
  public BBacnetMultistateOutput()
  {
  }


////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////

}
