/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.sys.*;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.*;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;

/**
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 26 Jul 2005
 * @since Niagara 3.1
 */
public class BBacnetGroup
  extends BBacnetObject
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY | Flags.DEFAULT_ON_CLONE,
    BBacnetObjectIdentifier.make(BBacnetObjectType.GROUP),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.GROUP,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

  /*-

  class BBacnetGroup
  {
    properties
    {
      listOfGroupMembers: BBacnetListOf
        default {[ new BBacnetListOf(BReadAccessSpecification.TYPE) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.LIST_OF_GROUP_MEMBERS,
                                 ASN_BACNET_LIST) ]}
      presentValue: BBacnetListOf
        default {[ new BBacnetListOf(BReadAccessResult.TYPE) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE,
                                 ASN_BACNET_LIST) ]}
    }

    actions
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetGroup(310618396)1.0$ @*/
/* Generated Wed Aug 09 14:29:56 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "listOfGroupMembers"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>listOfGroupMembers</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetGroup#getListOfGroupMembers
   * @see javax.baja.bacnet.config.BBacnetGroup#setListOfGroupMembers
   */
  public static final Property listOfGroupMembers = newProperty(0, new BBacnetListOf(BReadAccessSpecification.TYPE), makeFacets(BBacnetPropertyIdentifier.LIST_OF_GROUP_MEMBERS,
    ASN_BACNET_LIST));

  /**
   * Get the <code>listOfGroupMembers</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetGroup#listOfGroupMembers
   */
  public BBacnetListOf getListOfGroupMembers()
  {
    return (BBacnetListOf)get(listOfGroupMembers);
  }

  /**
   * Set the <code>listOfGroupMembers</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetGroup#listOfGroupMembers
   */
  public void setListOfGroupMembers(BBacnetListOf v)
  {
    set(listOfGroupMembers, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "presentValue"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetGroup#getPresentValue
   * @see javax.baja.bacnet.config.BBacnetGroup#setPresentValue
   */
  public static final Property presentValue = newProperty(0, new BBacnetListOf(BReadAccessResult.TYPE), makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE,
    ASN_BACNET_LIST));

  /**
   * Get the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetGroup#presentValue
   */
  public BBacnetListOf getPresentValue()
  {
    return (BBacnetListOf)get(presentValue);
  }

  /**
   * Set the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetGroup#presentValue
   */
  public void setPresentValue(BBacnetListOf v)
  {
    set(presentValue, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetGroup.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BBacnetGroup()
  {
  }


////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  public String toString(Context context)
  {
    return getObjectId().toString(context);
  }


////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  BComponent
////////////////////////////////////////////////////////////////

  /**
   * Property changed.
   public void changed(Property p, Context cx)
   {
   super.changed(p,cx);
   if (!isRunning()) return;
   }
   */

////////////////////////////////////////////////////////////////
//  Overrides
////////////////////////////////////////////////////////////////

  /**
   * Subclasses that have a present value property should
   * override this method and return this property.  The
   * default returns null.
   */
  public Property getPresentValueProperty()
  {
    return presentValue;
  }

////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  Attributes
////////////////////////////////////////////////////////////////

}
