/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.io.PropertyValue;
import javax.baja.nre.util.Array;
import javax.baja.sys.*;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetCalendarEntry;
import javax.baja.bacnet.datatypes.BBacnetListOf;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;

/**
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 15 Nov 02
 * @since Niagara 3 Bacnet 1.0
 */
public class BBacnetCalendar
  extends BBacnetCreatableObject
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.CALENDAR),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.CALENDAR,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

  /*-

  class BBacnetCalendar
  {
    properties
    {
      presentValue: boolean
        default {[ false ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE,
                                 ASN_BOOLEAN) ]}
      datelist: BBacnetListOf
        default {[ new BBacnetListOf(BBacnetCalendarEntry.TYPE) ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.DATE_LIST,
                                 ASN_BACNET_LIST) ]}
    }

    actions
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetCalendar(4109513178)1.0$ @*/
/* Generated Wed Jun 02 14:56:18 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "presentValue"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetCalendar#getPresentValue
   * @see javax.baja.bacnet.config.BBacnetCalendar#setPresentValue
   */
  public static final Property presentValue = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE,
    ASN_BOOLEAN));

  /**
   * Get the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetCalendar#presentValue
   */
  public boolean getPresentValue()
  {
    return getBoolean(presentValue);
  }

  /**
   * Set the <code>presentValue</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetCalendar#presentValue
   */
  public void setPresentValue(boolean v)
  {
    setBoolean(presentValue, v, null);
  }

////////////////////////////////////////////////////////////////
// Property "datelist"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>datelist</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetCalendar#getDatelist
   * @see javax.baja.bacnet.config.BBacnetCalendar#setDatelist
   */
  public static final Property datelist = newProperty(0, new BBacnetListOf(BBacnetCalendarEntry.TYPE), makeFacets(BBacnetPropertyIdentifier.DATE_LIST,
    ASN_BACNET_LIST));

  /**
   * Get the <code>datelist</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetCalendar#datelist
   */
  public BBacnetListOf getDatelist()
  {
    return (BBacnetListOf)get(datelist);
  }

  /**
   * Set the <code>datelist</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetCalendar#datelist
   */
  public void setDatelist(BBacnetListOf v)
  {
    set(datelist, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetCalendar.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public BBacnetCalendar()
  {
  }


////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  public String toString(Context context)
  {
    StringBuilder sb = new StringBuilder();
    sb.append(getObjectId().toString(context))
      .append(nameContext.equals(context) ? '_' : ':')
      .append(getPresentValue());
    return sb.toString();
  }


////////////////////////////////////////////////////////////////
// Actions
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  BComponent
////////////////////////////////////////////////////////////////

  /**
   * Property changed.
   public void changed(Property p, Context cx)
   {
   super.changed(p,cx);
   if (!isRunning()) return;
   }
   */

////////////////////////////////////////////////////////////////
//  Overrides
////////////////////////////////////////////////////////////////


  @Override
  protected void addObjectInitialValues(Array<PropertyValue> listOfInitialValues)
  {
    // No Calendar specific properties to be added as of now.
  }

  /**
   * Subclasses that have a present value property should
   * override this method and return this property.  The
   * default returns null.
   */
  public Property getPresentValueProperty()
  {
    return presentValue;
  }

////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  Attributes
////////////////////////////////////////////////////////////////

}
