/*
 * Copyright 2001 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.sys.*;

import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPolarity;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;

/**
 * @author Craig Gemmill
 * @version $Revision: 8$ $Date: 12/10/01 9:26:04 AM$
 * @creation 14 Feb 01
 * @since Niagara 3 Bacnet 1.0
 */
public class BBacnetBinaryInput
  extends BBacnetBinary
{

////////////////////////////////////////////////////////////////
// Slot overrides
////////////////////////////////////////////////////////////////

  public static final Property objectId = newProperty(Flags.SUMMARY,
    BBacnetObjectIdentifier.make(BBacnetObjectType.BINARY_INPUT),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER,
      ASN_OBJECT_IDENTIFIER));

  public static final Property objectType = newProperty(Flags.READONLY,
    BDynamicEnum.make(BBacnetObjectType.BINARY_INPUT,
      BEnumRange.make(BBacnetObjectType.TYPE)),
    makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE,
      ASN_ENUMERATED));

  /*-

  class  BBacnetBinaryInput
  {
    properties
    {
      polarity: BBacnetPolarity
        -- polarity describes the relationship between the physical state
        -- of the point and the logical state represented by the presentValue
        -- property.
        default {[ BBacnetPolarity.normal ]}
        slotfacets {[ makeFacets(BBacnetPropertyIdentifier.POLARITY,
                                 ASN_ENUMERATED) ]}
    }

    actions
    {
    }
  }

  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.config.BBacnetBinaryInput(4147851553)1.0$ @*/
/* Generated Fri Sep 15 09:15:27 EDT 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "polarity"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>polarity</code> property.
   * polarity describes the relationship between the physical
   * state of the point and the logical state represented
   * by the presentValue property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinaryInput#getPolarity
   * @see javax.baja.bacnet.config.BBacnetBinaryInput#setPolarity
   */
  public static final Property polarity = newProperty(0, BBacnetPolarity.normal, makeFacets(BBacnetPropertyIdentifier.POLARITY,
    ASN_ENUMERATED));

  /**
   * Get the <code>polarity</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinaryInput#polarity
   */
  public BBacnetPolarity getPolarity()
  {
    return (BBacnetPolarity)get(polarity);
  }

  /**
   * Set the <code>polarity</code> property.
   *
   * @see javax.baja.bacnet.config.BBacnetBinaryInput#polarity
   */
  public void setPolarity(BBacnetPolarity v)
  {
    set(polarity, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetBinaryInput.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   */
  public BBacnetBinaryInput()
  {
  }


////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////
//  Constants
////////////////////////////////////////////////////////////////

}
