/*
 * Copyright 2004 Tridium, Inc.  All rights reserved.
 */
package javax.baja.bacnet.alarm;

import javax.baja.sys.*;

import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetAlarmConst;

import com.tridium.bacnet.stack.BBacnetStack;
import com.tridium.bacnet.stack.server.BEventHandler;

/**
 * BBacnetAlarmDeviceExt.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 23 Jul 2004
 * @since Niagara 3 BACnet 1.0
 */
public class BBacnetAlarmDeviceExt
  extends BAlarmDeviceExt
  implements BacnetAlarmConst
{

/////////////////////////////////////////////////////////////////
// Properties
/////////////////////////////////////////////////////////////////

  //  // Remove "Use Existing Alarm Class" choice.
  public static final Property alarmClass = newProperty(0, "defaultAlarmClass", BFacets.make(BFacets.FIELD_EDITOR, BString.make("alarm:AlarmClassFE"),
                                                                                                               BFacets.UX_FIELD_EDITOR, BString.make("alarm:AlarmClassEditor")));

  /*-
  class BBacnetAlarmDeviceExt
  {
    properties
    {
      niagaraProcessId:long
        default {[ 0 ]}
        slotfacets {[ BFacets.make(BFacets.MIN, BLong.make(0), BFacets.MAX, BLong.make(0x7FFFFFFF)) ]}
    }
    actions
    {
    }
    topics
    {
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.alarm.BBacnetAlarmDeviceExt(2429067326)1.0$ @*/
/* Generated Fri Dec 29 10:19:03 EST 2006 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "niagaraProcessId"
////////////////////////////////////////////////////////////////

  /**
   * Slot for the <code>niagaraProcessId</code> property.
   *
   * @see javax.baja.bacnet.alarm.BBacnetAlarmDeviceExt#getNiagaraProcessId
   * @see javax.baja.bacnet.alarm.BBacnetAlarmDeviceExt#setNiagaraProcessId
   */
  public static final Property niagaraProcessId = newProperty(0, 0, BFacets.make(BFacets.MIN, BLong.make(0), BFacets.MAX, BLong.make(0x7FFFFFFF)));

  /**
   * Get the <code>niagaraProcessId</code> property.
   *
   * @see javax.baja.bacnet.alarm.BBacnetAlarmDeviceExt#niagaraProcessId
   */
  public long getNiagaraProcessId()
  {
    return getLong(niagaraProcessId);
  }

  /**
   * Set the <code>niagaraProcessId</code> property.
   *
   * @see javax.baja.bacnet.alarm.BBacnetAlarmDeviceExt#niagaraProcessId
   */
  public void setNiagaraProcessId(long v)
  {
    setLong(niagaraProcessId, v, null);
  }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetAlarmDeviceExt.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


/////////////////////////////////////////////////////////////////
// Constructors
/////////////////////////////////////////////////////////////////

  public BBacnetAlarmDeviceExt()
  {
  }

/////////////////////////////////////////////////////////////////
// Actions
/////////////////////////////////////////////////////////////////

  public BBoolean doAckAlarm(BAlarmRecord ackRequest)
  {
    return getEventHandler().doAckAlarm(ackRequest);
  }

  public void doRouteAlarm(BAlarmRecord record)
    throws Exception
  {
    try
    {
      // Find the alarm service and route the alarm.  The alarm record already
      // has the correct alarm class in it for the default case (processId = 0).
      // If the processId is something other than our default, then check to see if
      // we have a specialized processor for it.
      BString s = (BString)record.getAlarmFacet(BAC_PROCESS_ID);
      if (s != null)
      {
        long processId = Long.parseLong(s.getString());

        // Check to see if Niagara should handle this.
        boolean noEventProcessor = true;
        if (processId == getNiagaraProcessId())
        {
          noEventProcessor = false;
          BAlarmService as = (BAlarmService)Sys.getService(BAlarmService.TYPE);
          as.routeAlarm(record);
        }

        // Check for other processors.
        SlotCursor<Property> sc = getProperties();
        while (sc.next(BBacnetEventProcessor.class))
        {
          BBacnetEventProcessor proc = (BBacnetEventProcessor)sc.get();
          if (proc.getProcessId() == processId)
          {
            noEventProcessor = false;
            proc.routeAlarm(record);
          }
        }

        if (noEventProcessor)
        {
          logger.info("AlarmDeviceExt(procId " + getNiagaraProcessId()
            + "): no event processor for alarm record:\n" + record);
        }
      }
    }
    catch (ServiceNotFoundException e)
    {
      logger.log(Level.SEVERE, "AlarmDeviceExt.processEvent:Unable to find Alarm Service!", e);
    }
  }

/////////////////////////////////////////////////////////////////
// Methods
/////////////////////////////////////////////////////////////////

  private BEventHandler getEventHandler()
  {
    return ((BBacnetStack)((BBacnetNetwork)getNetwork()).getBacnetComm())
      .getServer().getEventHandler();
  }

/////////////////////////////////////////////////////////////////
// Attributes
/////////////////////////////////////////////////////////////////

  private static final Logger logger = Logger.getLogger("bacnet");
}
