/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet;

import javax.baja.sys.*;

import javax.baja.agent.AgentList;
import javax.baja.driver.BDeviceFolder;

/**
 * BBacnetDeviceFolder.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 13 Sep 2004
 * @since Niagara 3 Bacnet 1.0
 */
public class BBacnetDeviceFolder
  extends BDeviceFolder
{
  /*-
  class BBacnetDeviceFolder
  {
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bacnet.BBacnetDeviceFolder(2175779404)1.0$ @*/
/* Generated Mon Sep 13 08:18:56 EDT 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BBacnetDeviceFolder.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

//  public void added(Property p, Context cx)
//  {
//    super.added(p, cx);
//
//    if (!isRunning() || (cx == Context.decoding)) return;
//    if (get(p) instanceof BBacnetDevice)
//      ((BBacnetDevice)get(p)).upload(new BUploadParameters(false));
//  }

  /**
   * BBacnetDeviceFolder may only be placed under a BBacnetNetwork or BBacnetDeviceFolder.
   */
  public boolean isParentLegal(BComponent parent)
  {
    return parent instanceof BBacnetNetwork || parent instanceof BBacnetDeviceFolder;
  }


////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////

  /**
   * @return the BBacnetDevice containing this BBacnetPointDeviceExt.
   */
  public final BBacnetNetwork network()
  {
    return (BBacnetNetwork)getNetwork();
  }


////////////////////////////////////////////////////////////////
// Presentation
////////////////////////////////////////////////////////////////

  /**
   * Get the agent list.  Remove Device Manager and Network Summary.
   */
  public AgentList getAgents(Context cx)
  {
    AgentList agents = super.getAgents(cx);
    agents.remove("driver:DeviceManager");
    agents.toBottom("bacnetEDE:EdeBacnetDeviceManager");
    return agents;
  }

  public String toString(Context cx)
  {
    return "BacnetDeviceFolder:" + getName();
  }


////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

}
