/*
 * Copyright 2011, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.velocity;

import org.apache.velocity.VelocityContext;

import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.web.BIWebProfile;
import javax.baja.web.WebOp;

/**
 * Interface for a Velocity Web Profile.
 * <p>
 * All Velocity Web Profiles must implement this interface.
 *
 * @author		gjohnson
 * @creation 	29 Jul 2011
 * @version 	1
 * @since 		Niagara 3.7
 */
public interface BIVelocityWebProfile
    extends BIWebProfile
{
  public static Type TYPE = Sys.loadType(BIVelocityWebProfile.class);
  
  /**
   * Return a new VelocityContext.
   * 
   * @param view  the view the Context is being created for
   * @param op  the current request's WebOp
   * 
   * @return VelocityContext
   */
  VelocityContext makeVelocityContext(BVelocityView view, WebOp op) throws Exception;
  
  /**
   * Write the view.
   * 
   * @param view  the view that needs to be written by the Profile
   * @param vContext  the Velocity Context used by the template generator
   * @param op  the current request's WebOp 
   */
  void write(BVelocityView view, VelocityContext vContext, WebOp op) throws Exception;

}
