/*
 * Copyright 2011, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.web.app;

import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BServiceContainer;
import javax.baja.web.app.BWebApp;

import com.tridium.box.BBoxService;
import com.tridium.sys.schema.Fw;

/**
 * BajaScript Web App
 * 
 *
 * @author		gjohnson
 * @creation 	27 Jul 2011
 * @version 	1
 * @since 		Niagara 3.7
 */
public abstract class BBajaScriptWebApp
    extends BWebApp
    implements BIBajaScriptWebApp
{
/*-
  class BBajaScriptWebApp
  {
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.bajascript.BBajaScriptWebApp(3867435812)1.0$ @*/
/* Generated Wed Jul 27 22:42:34 BST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBajaScriptWebApp.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
////////////////////////////////////////////////////////////////
// Framework
////////////////////////////////////////////////////////////////

  /**
   * Framework use only.
   */
  public Object fw(int x, Object a, Object b, Object c, Object d)
  {  
    switch(x)
    {
      case Fw.SERVICE_STARTED: fwServiceStarted(); break;
    }
    return super.fw(x, a, b, c, d);
  }  

  private void fwServiceStarted()
  {
    // For convenience, if the BoxService isn't available then automatically add it
    try
    {
      Sys.getService(BBoxService.TYPE);
    }
    catch(ServiceNotFoundException e)
    {
      try
      {
        // Add BoxService to services container...
        BServiceContainer services = (BServiceContainer)Sys.getService(BServiceContainer.TYPE);
        services.add("BoxService", new BBoxService());
      }
      catch(Throwable ignore) {}
    }
  }
  
////////////////////////////////////////////////////////////////
// App
////////////////////////////////////////////////////////////////
  
  public Type[] getRequiredServices()
  {
    // BajaScript requires the BOX Service to be installed...
    return append(super.getRequiredServices(), BBoxService.TYPE);
  }
}
