/*
 * Copyright 2011, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.app;

import javax.baja.sys.BIcon;
import javax.baja.sys.BInterface;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Interface for all App related Components
 *
 * @author		gjohnson
 * @creation 	11 Aug 2011
 * @version 	1
 * @since 		Niagara 3.7
 */
public interface BIAppComponent
    extends BInterface
{
  public static final Type TYPE = Sys.loadType(BIAppComponent.class);
  
  /**
   * Return the App Display Name.
   */
  public String getAppDisplayName(Context cx);
  
  /**
   * Return the App Display Icon.
   */
  public BIcon getAppDisplayIcon();
}
