/*
 * Copyright 2011, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.app;

import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.sys.schema.Fw;

/**
 * Niagara Application Folder 
 *
 * @author		gjohnson
 * @creation 	27 Jul 2011
 * @version 	1
 * @since 		Niagara 3.7
 */
public class BAppFolder
    extends BComponent
    implements BIAppFolder
{
/*-
  class BAppFolder
  {
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.app.BAppFolder(1649818394)1.0$ @*/
/* Generated Wed Jul 27 21:14:57 BST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAppFolder.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
 
////////////////////////////////////////////////////////////////
// Fw
////////////////////////////////////////////////////////////////  
  
  public Object fw(int x, Object a, Object b, Object c, Object d)
  {
    switch(x)
    {
      case Fw.STARTED: 
        container = (BAppContainer)Sys.getService(BAppContainer.TYPE); 
        break; 
      case Fw.ADDED:
      case Fw.REMOVED:
      case Fw.RENAMED:
      case Fw.REORDERED:
        if (isRunning() && Sys.atSteadyState()) container.fireAppsModified(null);
        break;
    }

    return super.fw(x, a, b, c, d);
  }
  
////////////////////////////////////////////////////////////////
// Object
////////////////////////////////////////////////////////////////  
  
  public BIcon getIcon() 
  { 
    BValue dynamic = get("icon");
    
    if (dynamic instanceof BIcon)
      return (BIcon)dynamic;
    
    return icon;
  }
  
////////////////////////////////////////////////////////////////
// Component
////////////////////////////////////////////////////////////////
  
  public final boolean isParentLegal(BComponent parent)
  {
    return parent instanceof BIAppFolder;
  }
  
////////////////////////////////////////////////////////////////
// App Component
////////////////////////////////////////////////////////////////
  
  public String getAppDisplayName(Context cx)
  {
    return getDisplayName(cx);
  }

  public BIcon getAppDisplayIcon()
  {
    return mobileIcon;
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  private static final BIcon icon = BIcon.make(BIcon.std("folder.png"), BIcon.std("badges/puzzle.png"));
  private static final BIcon mobileIcon = BIcon.make("module://mobile/rc/niagaraApps.png");
  private BAppContainer container = null;
}
