/*
 * Copyright 2011, Tridium, Inc. All Rights Reserved.
 */
package javax.baja.app;

import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

import com.tridium.sys.schema.Fw;

/**
 * Niagara Application Container
 *
 * @author		gjohnson
 * @creation 	27 Jul 2011
 * @version 	1
 * @since 		Niagara 3.7
 */
public final class BAppContainer
    extends BComponent
    implements BIService, BIAppFolder
{
/*-
  class BAppContainer
  {
    topics
    {
      appsModified
        -- Fired when the Apps or AppFolders are modified
        flags{ hidden }
    }
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.app.BAppContainer(68104215)1.0$ @*/
/* Generated Sat Dec 17 22:42:34 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Topic "appsModified"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>appsModified</code> topic.
   * Fired when the Apps or AppFolders are modified
   * @see javax.baja.app.BAppContainer#fireAppsModified
   */
  public static final Topic appsModified = newTopic(Flags.HIDDEN,null);
  
  /**
   * Fire an event for the <code>appsModified</code> topic.
   * Fired when the Apps or AppFolders are modified
   * @see javax.baja.app.BAppContainer#appsModified
   */
  public void fireAppsModified(BValue event) { fire(appsModified, event, null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAppContainer.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
////////////////////////////////////////////////////////////////
// Fw
////////////////////////////////////////////////////////////////  
  
  public Object fw(int x, Object a, Object b, Object c, Object d)
  {
    switch(x)
    {
      case Fw.ADDED:
      case Fw.REMOVED:
      case Fw.RENAMED:
      case Fw.REORDERED:
        if (isRunning() && Sys.atSteadyState()) fireAppsModified(null);
        break;
    }

    return super.fw(x, a, b, c, d);
  }  
  
////////////////////////////////////////////////////////////////
// Service
////////////////////////////////////////////////////////////////
  
  public Type[] getServiceTypes()
  {
    return new Type[] { getType() };
  }
  
  public void serviceStarted() throws Exception {}
  public void serviceStopped() throws Exception {}
  
////////////////////////////////////////////////////////////////
// Component
////////////////////////////////////////////////////////////////
  
  public BIcon getIcon()
  {
    return icon;
  }
  
////////////////////////////////////////////////////////////////
// App Component
////////////////////////////////////////////////////////////////
  
  public String getAppDisplayName(Context cx)
  {
    return Lexicon.make(TYPE.getModule(), cx).get("apps");
  }

  public BIcon getAppDisplayIcon()
  {
    return getIcon();
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  private static final BIcon icon = BIcon.std("appContainer.png");
}
