/*
 *
 * Copyright 2018 Tridium, Inc. All Rights Reserved.
 *
 */

package javax.bajax.analytics.time;

import java.time.Instant;
import java.time.ZoneId;
import java.time.zone.ZoneOffsetTransition;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import com.tridiumx.analytics.time.TimeBinding;
import com.tridiumx.analytics.util.Utils;

/**
 * Niagara enum implementation of the Interval interface.
 *
 * @author Aaron Hansen
 * @see Interval
 * @since NA 2.0
 */
public final class BInterval
  extends BFrozenEnum
  implements Interval
{

  /////////////////////////////////////////////////////////////////
  // Properties
  /////////////////////////////////////////////////////////////////

  /*-
  enum BInterval
  {
    range
    {
      none = INTERVAL_NONE,
      second = INTERVAL_SECOND,
      fiveSeconds = INTERVAL_FIVE_SECONDS,
      tenSeconds = INTERVAL_TEN_SECONDS,
      fifteenSeconds = INTERVAL_FIFTEEN_SECONDS,
      thirtySeconds = INTERVAL_THIRTY_SECONDS,
      minute = INTERVAL_MINUTE,
      fiveMinutes = INTERVAL_FIVE_MINUTES,
      tenMinutes = INTERVAL_TEN_MINUTES,
      fifteenMinutes = INTERVAL_FIFTEEN_MINUTES,
      twentyMinutes = INTERVAL_TWENTY_MINUTES,
      thirtyMinutes = INTERVAL_THIRTY_MINUTES,
      hour = INTERVAL_HOUR,
      twoHours = INTERVAL_TWO_HOURS,
      threeHours = INTERVAL_THREE_HOURS,
      fourHours = INTERVAL_FOUR_HOURS,
      sixHours = INTERVAL_SIX_HOURS,
      twelveHours = INTERVAL_TWELVE_HOURS,
      day = INTERVAL_DAY,
      week = INTERVAL_WEEK,
      month = INTERVAL_MONTH,
      quarter = INTERVAL_QUARTER,
      year = INTERVAL_YEAR,
    }
  }
  -*/
  /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
  /*@ $javax.bajax.analytics.time.BInterval(3974100160)1.0$ @*/
  /* Generated Fri Nov 27 10:57:38 PST 2015 by Slot-o-Matic (c) Tridium, Inc. 2012 */

  /**
   * Ordinal value for none.
   */
  public static final int NONE = 0;
  /**
   * Ordinal value for second.
   */
  public static final int SECOND = 1;
  /**
   * Ordinal value for fiveSeconds.
   */
  public static final int FIVE_SECONDS = 2;
  /**
   * Ordinal value for tenSeconds.
   */
  public static final int TEN_SECONDS = 3;
  /**
   * Ordinal value for fifteenSeconds.
   */
  public static final int FIFTEEN_SECONDS = 4;
  /**
   * Ordinal value for thirtySeconds.
   */
  public static final int THIRTY_SECONDS = 5;
  /**
   * Ordinal value for minute.
   */
  public static final int MINUTE = 6;
  /**
   * Ordinal value for fiveMinutes.
   */
  public static final int FIVE_MINUTES = 7;
  /**
   * Ordinal value for tenMinutes.
   */
  public static final int TEN_MINUTES = 8;
  /**
   * Ordinal value for fifteenMinutes.
   */
  public static final int FIFTEEN_MINUTES = 9;
  /**
   * Ordinal value for twentyMinutes.
   */
  public static final int TWENTY_MINUTES = 10;
  /**
   * Ordinal value for thirtyMinutes.
   */
  public static final int THIRTY_MINUTES = 11;
  /**
   * Ordinal value for hour.
   */
  public static final int HOUR = 12;
  /**
   * Ordinal value for twoHours.
   */
  public static final int TWO_HOURS = 13;
  /**
   * Ordinal value for threeHours.
   */
  public static final int THREE_HOURS = 14;
  /**
   * Ordinal value for fourHours.
   */
  public static final int FOUR_HOURS = 15;
  /**
   * Ordinal value for sixHours.
   */
  public static final int SIX_HOURS = 16;
  /**
   * Ordinal value for twelveHours.
   */
  public static final int TWELVE_HOURS = 17;
  /**
   * Ordinal value for day.
   */
  public static final int DAY = 18;
  /**
   * Ordinal value for week.
   */
  public static final int WEEK = 19;
  /**
   * Ordinal value for month.
   */
  public static final int MONTH = 20;
  /**
   * Ordinal value for quarter.
   */
  public static final int QUARTER = 21;
  /**
   * Ordinal value for year.
   */
  public static final int YEAR = 22;

  /**
   * BInterval constant for none.
   */
  public static final BInterval none = new BInterval(NONE);
  /**
   * BInterval constant for second.
   */
  public static final BInterval second = new BInterval(SECOND);
  /**
   * BInterval constant for fiveSeconds.
   */
  public static final BInterval fiveSeconds = new BInterval(FIVE_SECONDS);
  /**
   * BInterval constant for tenSeconds.
   */
  public static final BInterval tenSeconds = new BInterval(TEN_SECONDS);
  /**
   * BInterval constant for fifteenSeconds.
   */
  public static final BInterval fifteenSeconds = new BInterval(FIFTEEN_SECONDS);
  /**
   * BInterval constant for thirtySeconds.
   */
  public static final BInterval thirtySeconds = new BInterval(THIRTY_SECONDS);
  /**
   * BInterval constant for minute.
   */
  public static final BInterval minute = new BInterval(MINUTE);
  /**
   * BInterval constant for fiveMinutes.
   */
  public static final BInterval fiveMinutes = new BInterval(FIVE_MINUTES);
  /**
   * BInterval constant for tenMinutes.
   */
  public static final BInterval tenMinutes = new BInterval(TEN_MINUTES);
  /**
   * BInterval constant for fifteenMinutes.
   */
  public static final BInterval fifteenMinutes = new BInterval(FIFTEEN_MINUTES);
  /**
   * BInterval constant for twentyMinutes.
   */
  public static final BInterval twentyMinutes = new BInterval(TWENTY_MINUTES);
  /**
   * BInterval constant for thirtyMinutes.
   */
  public static final BInterval thirtyMinutes = new BInterval(THIRTY_MINUTES);
  /**
   * BInterval constant for hour.
   */
  public static final BInterval hour = new BInterval(HOUR);
  /**
   * BInterval constant for twoHours.
   */
  public static final BInterval twoHours = new BInterval(TWO_HOURS);
  /**
   * BInterval constant for threeHours.
   */
  public static final BInterval threeHours = new BInterval(THREE_HOURS);
  /**
   * BInterval constant for fourHours.
   */
  public static final BInterval fourHours = new BInterval(FOUR_HOURS);
  /**
   * BInterval constant for sixHours.
   */
  public static final BInterval sixHours = new BInterval(SIX_HOURS);
  /**
   * BInterval constant for twelveHours.
   */
  public static final BInterval twelveHours = new BInterval(TWELVE_HOURS);
  /**
   * BInterval constant for day.
   */
  public static final BInterval day = new BInterval(DAY);
  /**
   * BInterval constant for week.
   */
  public static final BInterval week = new BInterval(WEEK);
  /**
   * BInterval constant for month.
   */
  public static final BInterval month = new BInterval(MONTH);
  /**
   * BInterval constant for quarter.
   */
  public static final BInterval quarter = new BInterval(QUARTER);
  /**
   * BInterval constant for year.
   */
  public static final BInterval year = new BInterval(YEAR);

  /**
   * Factory method with ordinal.
   */
  public static BInterval make(int ordinal)
  {
    return (BInterval)none.getRange().get(ordinal, false);
  }

  /**
   * Factory method with tag.
   */
  public static BInterval make(String tag)
  {
    return (BInterval)none.getRange().get(tag);
  }

  /**
   * Private constructor.
   */
  private BInterval(int ordinal)
  {
    super(ordinal);
  }

  public static final BInterval DEFAULT = none;

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  @Override
  public Type getType()
  {
    return TYPE;
  }

  public static final Type TYPE = Sys.loadType(BInterval.class);

  /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


  /**
   * Returns the number of intervals for the given time range, or -1
   * if indeterminate.
   */
  public int count(long start, long end)
  {
    if ((start < 0) || (end < 0))
      return -1;
    long delta = end - start;
    int type = getOrdinal();
    switch (type)
    {
      case INTERVAL_NONE:
        return (int)delta;
      case INTERVAL_SECOND:
      case INTERVAL_FIVE_SECONDS:
      case INTERVAL_TEN_SECONDS:
      case INTERVAL_FIFTEEN_SECONDS:
      case INTERVAL_THIRTY_SECONDS:
      case INTERVAL_MINUTE:
      case INTERVAL_FIVE_MINUTES:
      case INTERVAL_TEN_MINUTES:
      case INTERVAL_FIFTEEN_MINUTES:
      case INTERVAL_TWENTY_MINUTES:
      case INTERVAL_THIRTY_MINUTES:
      case INTERVAL_HOUR:
      case INTERVAL_TWO_HOURS:
      case INTERVAL_THREE_HOURS:
      case INTERVAL_FOUR_HOURS:
      case INTERVAL_SIX_HOURS:
      case INTERVAL_TWELVE_HOURS:
      case INTERVAL_DAY:
      case INTERVAL_WEEK:
        return (int)(delta / millis());
    }
    int ret = 0;
    if (start < end)
    {
      while (start < end)
      {
        ret++;
        start = next(start);
      }
    }
    else
    {
      while (end < start)
      {
        ret++;
        end = next(end);
      }
    }
    return ret;
  }

  /**
   * The approximate number of ms in the interval.
   */
  public long millis()
  {
    switch (getOrdinal())
    {
      case INTERVAL_NONE:
        return 1;
      case INTERVAL_SECOND:
        return MILLIS_SECOND;
      case INTERVAL_FIVE_SECONDS:
        return MILLIS_FIVE_SECONDS;
      case INTERVAL_TEN_SECONDS:
        return MILLIS_TEN_SECONDS;
      case INTERVAL_FIFTEEN_SECONDS:
        return MILLIS_FIFTEEN_SECONDS;
      case INTERVAL_THIRTY_SECONDS:
        return MILLIS_THIRTY_SECONDS;
      case INTERVAL_MINUTE:
        return MILLIS_MINUTE;
      case INTERVAL_FIVE_MINUTES:
        return MILLIS_FIVE_MINUTES;
      case INTERVAL_TEN_MINUTES:
        return MILLIS_TEN_MINUTES;
      case INTERVAL_FIFTEEN_MINUTES:
        return MILLIS_FIFTEEN_MINUTES;
      case INTERVAL_TWENTY_MINUTES:
        return MILLIS_TWENTY_MINUTES;
      case INTERVAL_THIRTY_MINUTES:
        return MILLIS_THIRTY_MINUTES;
      case INTERVAL_HOUR:
        return MILLIS_HOUR;
      case INTERVAL_TWO_HOURS:
        return MILLIS_TWO_HOURS;
      case INTERVAL_THREE_HOURS:
        return MILLIS_THREE_HOURS;
      case INTERVAL_FOUR_HOURS:
        return MILLIS_FOUR_HOURS;
      case INTERVAL_SIX_HOURS:
        return MILLIS_SIX_HOURS;
      case INTERVAL_TWELVE_HOURS:
        return MILLIS_TWELVE_HOURS;
      case INTERVAL_DAY:
        return MILLIS_DAY;
      case INTERVAL_WEEK:
        return MILLIS_WEEK;
      case INTERVAL_MONTH:
        return MILLIS_MONTH;
      case INTERVAL_QUARTER:
        return MILLIS_QUARTER;
      case INTERVAL_YEAR:
        return MILLIS_YEAR;
    }
    throw new IllegalStateException(
      Utils.lex("unknownInterval") + ": " + getOrdinal());
  }

  /**
   * Returns the next interval for the previously aligned timestamp.
   */
  private ZoneId zoneId = ZoneId.of(TimeBinding.getTimeZone().getID());


  private int adjustH(long ts, int hours)
  {
    Instant ins = Instant.ofEpochMilli(ts);
    ZoneOffsetTransition zoneOffsetTransition = zoneId.getRules().nextTransition(ins);
    if (zoneId.getRules().nextTransition(ins) != null)
    {
      long nextChange = zoneOffsetTransition.toEpochSecond();
      boolean isDST = zoneId.getRules().isDaylightSavings(ins);
      long calcNextInterval = (ts + (hours * MILLIS_HOUR));
      if (!isDST && (calcNextInterval / 1000) >= nextChange)
      {
        calcNextInterval = calcNextInterval - MILLIS_HOUR;
        //Adjust the hours to be added to align it to next interval.
        if (((calcNextInterval) / 1000) >= nextChange)
        {
          return hours - 1;
        }
        //Skip one interval, if it aligned to the next interval.
        return (2 * hours) - 1;
      }
      else if (isDST && (calcNextInterval / 1000) >= nextChange)
      {
        return hours + 1;
      }
    }
    return hours;
  }

  public long next(long timestamp)
  {
    long ts = timestamp;

    switch (getOrdinal())
    {
      case INTERVAL_NONE:
        return ts + 1;
      case INTERVAL_SECOND:
        return ts + MILLIS_SECOND;
      case INTERVAL_FIVE_SECONDS:
        return ts + MILLIS_FIVE_SECONDS;
      case INTERVAL_TEN_SECONDS:
        return ts + MILLIS_TEN_SECONDS;
      case INTERVAL_FIFTEEN_SECONDS:
        return ts + MILLIS_FIFTEEN_SECONDS;
      case INTERVAL_THIRTY_SECONDS:
        return ts + MILLIS_THIRTY_SECONDS;
      case INTERVAL_MINUTE:
        return ts + MILLIS_MINUTE;
      case INTERVAL_FIVE_MINUTES:
        return ts + MILLIS_FIVE_MINUTES;
      case INTERVAL_TEN_MINUTES:
        return ts + MILLIS_TEN_MINUTES;
      case INTERVAL_FIFTEEN_MINUTES:
        return ts + MILLIS_FIFTEEN_MINUTES;
      case INTERVAL_TWENTY_MINUTES:
        return ts + MILLIS_TWENTY_MINUTES;
      case INTERVAL_THIRTY_MINUTES:
        return ts + MILLIS_THIRTY_MINUTES;
      case INTERVAL_HOUR:
        return TimeBinding.addHours(1, ts);
      case INTERVAL_TWO_HOURS:
        return TimeBinding.addHours(adjustH(ts, 2), ts);
      case INTERVAL_THREE_HOURS:
        return TimeBinding.addHours(adjustH(ts, 3), ts);
      case INTERVAL_FOUR_HOURS:
        return TimeBinding.addHours(adjustH(ts, 4), ts);
      case INTERVAL_SIX_HOURS:
        return TimeBinding.addHours(adjustH(ts, 6), ts);
      case INTERVAL_TWELVE_HOURS:
        return TimeBinding.addHours(adjustH(ts, 12), ts);
      case INTERVAL_DAY:
        return TimeBinding.addDays(1, ts);
      case INTERVAL_WEEK:
        return TimeBinding.addWeeks(1, ts);
      case INTERVAL_MONTH:
        return TimeBinding.addMonths(1, ts);
      case INTERVAL_QUARTER:
        return TimeBinding.addMonths(3, ts);
      case INTERVAL_YEAR:
        return TimeBinding.addYears(1, ts);
    }
    throw new IllegalStateException(
      Utils.lex("unknownInterval") + ": " + getOrdinal());
  }

  /**
   * Get the previous time stamp based on the intervals
   *
   * @param timestamp
   * @return
   */
  public long previous(long timestamp)
  {
    long ts = timestamp;

    switch (getOrdinal())
    {
      case INTERVAL_NONE:
        return ts - 1;
      case INTERVAL_SECOND:
        return ts - MILLIS_SECOND;
      case INTERVAL_FIVE_SECONDS:
        return ts - MILLIS_FIVE_SECONDS;
      case INTERVAL_TEN_SECONDS:
        return ts - MILLIS_TEN_SECONDS;
      case INTERVAL_FIFTEEN_SECONDS:
        return ts - MILLIS_FIFTEEN_SECONDS;
      case INTERVAL_THIRTY_SECONDS:
        return ts - MILLIS_THIRTY_SECONDS;
      case INTERVAL_MINUTE:
        return ts - MILLIS_MINUTE;
      case INTERVAL_FIVE_MINUTES:
        return ts - MILLIS_FIVE_MINUTES;
      case INTERVAL_TEN_MINUTES:
        return ts - MILLIS_TEN_MINUTES;
      case INTERVAL_FIFTEEN_MINUTES:
        return ts - MILLIS_FIFTEEN_MINUTES;
      case INTERVAL_TWENTY_MINUTES:
        return ts - MILLIS_TWENTY_MINUTES;
      case INTERVAL_THIRTY_MINUTES:
        return ts - MILLIS_THIRTY_MINUTES;
      case INTERVAL_HOUR:
        return TimeBinding.addHours(-1, ts);
      case INTERVAL_TWO_HOURS:
        return TimeBinding.addHours(-2, ts);
      case INTERVAL_THREE_HOURS:
        return TimeBinding.addHours(-3, ts);
      case INTERVAL_FOUR_HOURS:
        return TimeBinding.addHours(-4, ts);
      case INTERVAL_SIX_HOURS:
        return TimeBinding.addHours(-6, ts);
      case INTERVAL_TWELVE_HOURS:
        return TimeBinding.addHours(-12, ts);
      case INTERVAL_DAY:
        return TimeBinding.addDays(-1, ts);
      case INTERVAL_WEEK:
        return TimeBinding.addWeeks(-1, ts);
      case INTERVAL_MONTH:
        return TimeBinding.addMonths(-1, ts);
      case INTERVAL_QUARTER:
        return TimeBinding.addMonths(-3, ts);
      case INTERVAL_YEAR:
        return TimeBinding.addYears(-1, ts);
      default:
        throw new IllegalStateException(
          Utils.lex("unknownInterval") + ": " + getOrdinal());
    }

  }


}
