/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.alarmOrion;

import javax.baja.naming.BOrd;
import com.tridium.orion.*;
import com.tridium.orion.sql.PropertyValue;
import javax.baja.rdb.ddl.*;
import javax.baja.sys.*;

public class BOrionAlarmSourceOrder
  extends BOrionObject
{
  /*-
  @Mode(Orion)
  class BOrionAlarmSourceOrder
  {
    properties
    {
      id: int
        flags { readonly, summary }
        default {[ -1 ]}
        slotfacets {[ ID_KEY, CLUSTERED = false ]}
    
      @Ref(BOrionAlarmRecord)
      alarm: BRef
        flags { summary }
        default {[ BRef.make("alarmOrion:OrionAlarmRecord") ]}
        slotfacets {[ INDEXED = true, CLUSTERED = true, DESCENDING = true, ON_DELETE = BOnDelete.CASCADE ]}
        
      @Ref(BOrionAlarmSource)
      alarmSource: BRef
        flags { summary }
        default {[ BRef.make("alarmOrion:OrionAlarmSource") ]}
        slotfacets {[ ON_DELETE = BOnDelete.CASCADE, AUTO_RESOLVE = true ]}        
      
      sourceOrder: int
        -- The path to the source of the alarm.
        flags {summary}
        default {[0]}

    }
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.alarmOrion.BOrionAlarmSourceOrder(622703569)1.0$ @*/
/* Generated Wed Mar 17 11:09:34 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "id"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#getId
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#setId
   */
  public static final Property id = newProperty(Flags.READONLY|Flags.SUMMARY, -1,BFacets.make(ID_KEY,BFacets.make(CLUSTERED,false)));
  
  /**
   * Get the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#id
   */
  public int getId() { return getInt(id); }
  
  /**
   * Set the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#id
   */
  public void setId(int v) { setInt(id,v,null); }

////////////////////////////////////////////////////////////////
// Property "alarm"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>alarm</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#getAlarm
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#setAlarm
   */
  public static final Property alarm = newProperty(Flags.SUMMARY, BRef.make("alarmOrion:OrionAlarmRecord"),BFacets.make(BFacets.make(BFacets.make(BFacets.make(INDEXED,true),BFacets.make(CLUSTERED,true)),BFacets.make(DESCENDING,true)),BFacets.make(ON_DELETE,BOnDelete.CASCADE)));
  
  /**
   * Get the <code>alarm</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#alarm
   */
  public BRef getAlarm() { return (BRef)get(alarm); }
  
  /**
   * Set the <code>alarm</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#alarm
   */
  public void setAlarm(BRef v) { set(alarm,v,null); }
  
  /**
   * Resolve the <code>alarm</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#alarm
   */
  public BOrionAlarmRecord resolveAlarm(OrionSession session)
  {
    return (BOrionAlarmRecord)getAlarm().getTarget(session);
  }

////////////////////////////////////////////////////////////////
// Property "alarmSource"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>alarmSource</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#getAlarmSource
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#setAlarmSource
   */
  public static final Property alarmSource = newProperty(Flags.SUMMARY, BRef.make("alarmOrion:OrionAlarmSource"),BFacets.make(BFacets.make(ON_DELETE,BOnDelete.CASCADE),BFacets.make(AUTO_RESOLVE,true)));
  
  /**
   * Get the <code>alarmSource</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#alarmSource
   */
  public BRef getAlarmSource() { return (BRef)get(alarmSource); }
  
  /**
   * Set the <code>alarmSource</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#alarmSource
   */
  public void setAlarmSource(BRef v) { set(alarmSource,v,null); }
  
  /**
   * Resolve the <code>alarmSource</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#alarmSource
   */
  public BOrionAlarmSource resolveAlarmSource(OrionSession session)
  {
    return (BOrionAlarmSource)getAlarmSource().getTarget(session);
  }

////////////////////////////////////////////////////////////////
// Property "sourceOrder"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>sourceOrder</code> property.
   * The path to the source of the alarm.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#getSourceOrder
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#setSourceOrder
   */
  public static final Property sourceOrder = newProperty(Flags.SUMMARY, 0,null);
  
  /**
   * Get the <code>sourceOrder</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#sourceOrder
   */
  public int getSourceOrder() { return getInt(sourceOrder); }
  
  /**
   * Set the <code>sourceOrder</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmSourceOrder#sourceOrder
   */
  public void setSourceOrder(int v) { setInt(sourceOrder,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return getTypeFromSpace(TYPE); }
  public static final Type TYPE = Sys.loadType(BOrionAlarmSourceOrder.class);
  public static final OrionType ORION_TYPE = (OrionType)TYPE;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Create a BOrionAlarmSourceOrder object for the specified alarm.
   */
  public static BOrionAlarmSourceOrder make(BOrd ord, int index, BOrionAlarmRecord alarm, OrionSession session)
  {
    
    BOrionAlarmSource alarmSource = (BOrionAlarmSource)session.read(BOrionAlarmSource.ORION_TYPE, new PropertyValue(BOrionAlarmSource.source, ord));
    if(alarmSource==null)
    {
      alarmSource = new BOrionAlarmSource();
      alarmSource.setSource(ord);
      session.insert(alarmSource);
    }
    BOrionAlarmSourceOrder sourceOrder = new BOrionAlarmSourceOrder();
    sourceOrder.setAlarmSource(BRef.make(alarmSource));
    sourceOrder.setSourceOrder(index);
    sourceOrder.setAlarm(BRef.make(alarm));
    return sourceOrder;
  }
}
