/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.alarmOrion;

import com.tridium.orion.*;
import com.tridium.orion.sql.PropertyValue;
import javax.baja.sys.*;

import com.tridium.alarmOrion.OrionObjectCache;

/**
 * The representation of an alarm data facet name within the orion database.
 *
 * @author Lee Adcock
 * @creation March 18, 2009
 */
public class BOrionAlarmFacetName
  extends BOrionObject
{
  /*-
  @Mode(Orion)
  class BOrionAlarmFacetName
  {
    properties
    {
      id: int
        flags { readonly, summary }
        default {[ -1 ]}
        slotfacets {[ ID_KEY ]}
                
      facetName: String
        flags {summary}
        default {[""]}
        slotfacets {[ WIDTH=128, UNIQUE = true ]}
    }
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.alarmOrion.BOrionAlarmFacetName(2985303433)1.0$ @*/
/* Generated Tue Jul 10 09:20:11 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "id"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetName#getId
   * @see javax.baja.alarmOrion.BOrionAlarmFacetName#setId
   */
  public static final Property id = newProperty(Flags.READONLY|Flags.SUMMARY, -1,ID_KEY);
  
  /**
   * Get the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetName#id
   */
  public int getId() { return getInt(id); }
  
  /**
   * Set the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetName#id
   */
  public void setId(int v) { setInt(id,v,null); }

////////////////////////////////////////////////////////////////
// Property "facetName"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>facetName</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetName#getFacetName
   * @see javax.baja.alarmOrion.BOrionAlarmFacetName#setFacetName
   */
  public static final Property facetName = newProperty(Flags.SUMMARY, "",BFacets.make(BFacets.make(WIDTH,128),BFacets.make(UNIQUE,true)));
  
  /**
   * Get the <code>facetName</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetName#facetName
   */
  public String getFacetName() { return getString(facetName); }
  
  /**
   * Set the <code>facetName</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmFacetName#facetName
   */
  public void setFacetName(String v) { setString(facetName,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return getTypeFromSpace(TYPE); }
  public static final Type TYPE = Sys.loadType(BOrionAlarmFacetName.class);
  public static final OrionType ORION_TYPE = (OrionType)TYPE;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  /**
   * Get the facet record of the specified name.  If one does not exist, create it.
   * The results are cached to speed up multiple requests for the same object.
   */  
  public static BOrionAlarmFacetName get(String key, OrionSession session)
  {
    if(cacheName.contains(key))
      return (BOrionAlarmFacetName)cacheName.get(key);

    BOrionAlarmFacetName dataName;
    try (OrionCursor cursor = session.select(BOrionAlarmFacetName.ORION_TYPE, new PropertyValue(BOrionAlarmFacetName.facetName, BString.make(key))))
    {
      if (cursor.next())
      {
        dataName = (BOrionAlarmFacetName) cursor.get();
      }
      else
      {
        dataName = new BOrionAlarmFacetName();
        dataName.setFacetName(key);
        session.insert(dataName);
      }
      cacheName.put(key, dataName);
    }
    return dataName;
  }
  
  /**
   * Get the facet record of the specified name.  If one does not exist, create it.
   * The results are cached to speed up multiple requests for the same object.
   */  
  public static BOrionAlarmFacetName get(int id, OrionSession session)
  {
    BInteger intId = BInteger.make(id);
    if(cacheId.contains(intId))
      return (BOrionAlarmFacetName)cacheId.get(intId);
    
    OrionCursor cursor = session.select(BOrionAlarmFacetName.ORION_TYPE, new PropertyValue(BOrionAlarmFacetName.id, intId));
    BOrionAlarmFacetName dataName;
    if(cursor.next())
    {
      dataName = (BOrionAlarmFacetName)cursor.get();
      cursor.close();
      cacheId.put(intId, dataName);
    } else 
      throw new RuntimeException("Invalid facet name primary key.");
    
    return dataName;
  }  
  
  public void afterDelete(OrionSession session)
  {
    cacheName.remove(getFacetName());
    cacheId.remove(BInteger.make(getId()));
  }

  public void afterInsert(OrionSession session)
  {
    cacheName.put(getFacetName(), this);
    cacheId.put(BInteger.make(getId()), this);
  }

  public void afterUpdate(OrionSession session)
  {
    cacheName.update(getFacetName(), this);
    cacheId.update(BInteger.make(getId()), this);
  }

  private static OrionObjectCache cacheName = new OrionObjectCache(100);
  private static OrionObjectCache cacheId = new OrionObjectCache(100);
}
