/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.alarmOrion;

import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import com.tridium.orion.*;
import com.tridium.orion.sql.PropertyValue;
import javax.baja.sys.*;

import com.tridium.alarmOrion.OrionObjectCache;

/**
 * The representation of an alarm class within the orion database.
 *
 * @author Lee Adcock
 * @creation March 18, 2009
 */
public class BOrionAlarmClass
  extends BOrionObject
{
  /*-
  @Mode(Orion)
  class BOrionAlarmClass
  {
    properties
    {
      id: int
        flags { readonly, summary }
        default {[ -1 ]}
        slotfacets {[ ID_KEY ]}
                
      alarmClass: String
        flags {summary}
        default {[""]}
        slotfacets {[ UNIQUE = true, WIDTH = 64 ]}
        
      unackedAlarmCount: int
        flags { summary }
        default {[ 0 ]}
        
      openAlarmCount: int
        flags { summary }
        default {[ 0 ]}
        
      inAlarmCount: int
        flags { summary }
        default {[ 0 ]}

      totalAlarmCount: int
        flags { summary }
        default {[ 0 ]}
        
      timeOfLastAlarm: BAbsTime
        flags { summary }
        default {[ BAbsTime.NULL ]}
                
    }
  }
-*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.alarmOrion.BOrionAlarmClass(322711196)1.0$ @*/
/* Generated Fri Mar 26 11:23:04 EDT 2010 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "id"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#getId
   * @see javax.baja.alarmOrion.BOrionAlarmClass#setId
   */
  public static final Property id = newProperty(Flags.READONLY|Flags.SUMMARY, -1,ID_KEY);
  
  /**
   * Get the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#id
   */
  public int getId() { return getInt(id); }
  
  /**
   * Set the <code>id</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#id
   */
  public void setId(int v) { setInt(id,v,null); }

////////////////////////////////////////////////////////////////
// Property "alarmClass"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>alarmClass</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#getAlarmClass
   * @see javax.baja.alarmOrion.BOrionAlarmClass#setAlarmClass
   */
  public static final Property alarmClass = newProperty(Flags.SUMMARY, "",BFacets.make(BFacets.make(UNIQUE,true),BFacets.make(WIDTH,64)));
  
  /**
   * Get the <code>alarmClass</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#alarmClass
   */
  public String getAlarmClass() { return getString(alarmClass); }
  
  /**
   * Set the <code>alarmClass</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#alarmClass
   */
  public void setAlarmClass(String v) { setString(alarmClass,v,null); }

////////////////////////////////////////////////////////////////
// Property "unackedAlarmCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>unackedAlarmCount</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#getUnackedAlarmCount
   * @see javax.baja.alarmOrion.BOrionAlarmClass#setUnackedAlarmCount
   */
  public static final Property unackedAlarmCount = newProperty(Flags.SUMMARY, 0,null);
  
  /**
   * Get the <code>unackedAlarmCount</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#unackedAlarmCount
   */
  public int getUnackedAlarmCount() { return getInt(unackedAlarmCount); }
  
  /**
   * Set the <code>unackedAlarmCount</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#unackedAlarmCount
   */
  public void setUnackedAlarmCount(int v) { setInt(unackedAlarmCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "openAlarmCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>openAlarmCount</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#getOpenAlarmCount
   * @see javax.baja.alarmOrion.BOrionAlarmClass#setOpenAlarmCount
   */
  public static final Property openAlarmCount = newProperty(Flags.SUMMARY, 0,null);
  
  /**
   * Get the <code>openAlarmCount</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#openAlarmCount
   */
  public int getOpenAlarmCount() { return getInt(openAlarmCount); }
  
  /**
   * Set the <code>openAlarmCount</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#openAlarmCount
   */
  public void setOpenAlarmCount(int v) { setInt(openAlarmCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "inAlarmCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>inAlarmCount</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#getInAlarmCount
   * @see javax.baja.alarmOrion.BOrionAlarmClass#setInAlarmCount
   */
  public static final Property inAlarmCount = newProperty(Flags.SUMMARY, 0,null);
  
  /**
   * Get the <code>inAlarmCount</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#inAlarmCount
   */
  public int getInAlarmCount() { return getInt(inAlarmCount); }
  
  /**
   * Set the <code>inAlarmCount</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#inAlarmCount
   */
  public void setInAlarmCount(int v) { setInt(inAlarmCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "totalAlarmCount"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>totalAlarmCount</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#getTotalAlarmCount
   * @see javax.baja.alarmOrion.BOrionAlarmClass#setTotalAlarmCount
   */
  public static final Property totalAlarmCount = newProperty(Flags.SUMMARY, 0,null);
  
  /**
   * Get the <code>totalAlarmCount</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#totalAlarmCount
   */
  public int getTotalAlarmCount() { return getInt(totalAlarmCount); }
  
  /**
   * Set the <code>totalAlarmCount</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#totalAlarmCount
   */
  public void setTotalAlarmCount(int v) { setInt(totalAlarmCount,v,null); }

////////////////////////////////////////////////////////////////
// Property "timeOfLastAlarm"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>timeOfLastAlarm</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#getTimeOfLastAlarm
   * @see javax.baja.alarmOrion.BOrionAlarmClass#setTimeOfLastAlarm
   */
  public static final Property timeOfLastAlarm = newProperty(Flags.SUMMARY, BAbsTime.NULL,null);
  
  /**
   * Get the <code>timeOfLastAlarm</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#timeOfLastAlarm
   */
  public BAbsTime getTimeOfLastAlarm() { return (BAbsTime)get(timeOfLastAlarm); }
  
  /**
   * Set the <code>timeOfLastAlarm</code> property.
   * @see javax.baja.alarmOrion.BOrionAlarmClass#timeOfLastAlarm
   */
  public void setTimeOfLastAlarm(BAbsTime v) { set(timeOfLastAlarm,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return getTypeFromSpace(TYPE); }
  public static final Type TYPE = Sys.loadType(BOrionAlarmClass.class);
  public static final OrionType ORION_TYPE = (OrionType)TYPE;

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Get the alarm class of the specified name.  If one does not exist, create it.
   * The results are cached to speed up multiple requests for the same object.
   */
  public static BOrionAlarmClass get(String alarmClassName, OrionSession session)
  {
    if(cache.contains(alarmClassName))
      return (BOrionAlarmClass)cache.get(alarmClassName);
    
    OrionCursor cursor = session.select(BOrionAlarmClass.ORION_TYPE, new PropertyValue(BOrionAlarmClass.alarmClass, BString.make(alarmClassName)));
    BOrionAlarmClass alarmClass;
    if(cursor.next())
    {
      alarmClass = (BOrionAlarmClass)cursor.get();
      cursor.close();
    } else {
      alarmClass = new BOrionAlarmClass();
      alarmClass.setAlarmClass(alarmClassName);
      session.insert(alarmClass);
    }
    
    cache.put(alarmClassName, alarmClass);
    
    return alarmClass;
  }
  
  public void afterDelete(OrionSession session)
  {
    cache.remove(getAlarmClass());
  }

  public void afterInsert(OrionSession session)
  {
    cache.put(getAlarmClass(), this);
    updateAlarmClass();
  }

  public void afterUpdate(OrionSession session)
  {
    cache.update(getAlarmClass(), this);
    updateAlarmClass();
  }
  
  /**
   * Update the alarm class component with the alarm statistics stored
   * within the database.
   */
  public void updateAlarmClass()
  {
    BAlarmService service = (BAlarmService)Sys.getService(BAlarmService.TYPE);
    BAlarmClass[] alarmClasses = service.getAlarmClasses();
    for(int i=0; i<alarmClasses.length; i++)
    {
      if(alarmClasses[i].getName().equals(getAlarmClass()))
      {
        alarmClasses[i].setUnackedAlarmCount(getUnackedAlarmCount());
        alarmClasses[i].setOpenAlarmCount(getOpenAlarmCount());
        alarmClasses[i].setInAlarmCount(getInAlarmCount());
        alarmClasses[i].setTotalAlarmCount(getTotalAlarmCount());
        alarmClasses[i].setTimeOfLastAlarm(getTimeOfLastAlarm());    
        break;
      }
    }    
  }

  private static OrionObjectCache cache = new OrionObjectCache(100);  
}
