/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.alarm.ext.offnormal;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.util.*;

import javax.baja.alarm.*;

import javax.baja.control.*;
import javax.baja.alarm.ext.*;
import javax.baja.control.enums.*;

/**
 * BBooleanCommandFailureAlgorithm implements command
 * failure alarm detection algorithm for boolean
 * objects as described in BACnet.  If feedback and output
 * values of the point are not equal for timeDelay duration,
 * an offnormal alarm is generated.
 * <p>
 *
 * @author    Dan Giorgis
 * @creation  04 May 01
 * @version   $Revision: 29$ $Date: 3/23/05 11:53:24 AM EST$
 * @since     Baja 1.0
 */
public class BBooleanCommandFailureAlgorithm
  extends BTwoStateAlgorithm
{
  /*-
  class BBooleanCommandFailureAlgorithm
  {
    properties
    {
      feedbackValue:  BStatusBoolean
      -- Feedback Value
        flags { summary }
        default {[ new BStatusBoolean() ]}
    }
  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.alarm.ext.offnormal.BBooleanCommandFailureAlgorithm(995094571)1.0$ @*/
/* Generated Sat Dec 17 21:33:33 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "feedbackValue"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>feedbackValue</code> property.
   * Feedback Value
   * @see javax.baja.alarm.ext.offnormal.BBooleanCommandFailureAlgorithm#getFeedbackValue
   * @see javax.baja.alarm.ext.offnormal.BBooleanCommandFailureAlgorithm#setFeedbackValue
   */
  public static final Property feedbackValue = newProperty(Flags.SUMMARY, new BStatusBoolean(),null);
  
  /**
   * Get the <code>feedbackValue</code> property.
   * Feedback Value
   * @see javax.baja.alarm.ext.offnormal.BBooleanCommandFailureAlgorithm#feedbackValue
   */
  public BStatusBoolean getFeedbackValue() { return (BStatusBoolean)get(feedbackValue); }
  
  /**
   * Set the <code>feedbackValue</code> property.
   * Feedback Value
   * @see javax.baja.alarm.ext.offnormal.BBooleanCommandFailureAlgorithm#feedbackValue
   */
  public void setFeedbackValue(BStatusBoolean v) { set(feedbackValue,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BBooleanCommandFailureAlgorithm.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
//  Parent checking
////////////////////////////////////////////////////////////////

  /**
   * A BBooleanCommandFailureAlgorithm's grandparent must implement
   * the BooleanPoint interface
   */
  @Override
  public boolean isGrandparentLegal(BComponent grandparent)
  {
    return (grandparent instanceof BBooleanPoint);
  }

////////////////////////////////////////////////////////////////
//  property changed processing
////////////////////////////////////////////////////////////////

  @Override
  public void changed(Property p, Context cx)
  {
    super.changed(p, cx);
    
    if (!isRunning()) return;
    
    if (p == feedbackValue)
      executePoint();
  }  
  
////////////////////////////////////////////////////////////////
//  Algorithm implementation
////////////////////////////////////////////////////////////////

  /**
   * Return true if the feedback value matches output value
   */
  @Override
  protected boolean isNormal(BStatusValue o)
  {
    BStatusBoolean out = (BStatusBoolean)o;
    return out.getValue() == getFeedbackValue().getValue();
  }

  /**
   *  Write the key-value pairs defining alarm data for the
   *  alarm algorithm and state to the given Facets.
   * <p>
   *  The alarm data for a Command Failure alarm is given by
   *  BACnet table 13-3, Standard Object Property Values
   *  returned in notifications.
   *
   * @param out The relevant control point status value
   * @param map The map.
   */
  @Override
  @SuppressWarnings({"rawtypes","unchecked"})
  public void writeAlarmData(BStatusValue out, java.util.Map map)
  {
    map.put(BAlarmRecord.STATUS, BString.make(out.getStatus().toString(null)));
    map.put(BAlarmRecord.NUMERIC_VALUE, BInteger.make(((BStatusBoolean)out).getEnum().getOrdinal()));
    map.put(BAlarmRecord.FEEDBACK_VALUE,  BString.make(getFeedbackValue().valueToString(getPointFacets())));
    map.put(BAlarmRecord.FEEDBACK_NUMERIC, BInteger.make(getFeedbackValue().getEnum().getOrdinal()));
  }

}