/*
 * Copyright 2000 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.alarm.ext;

import java.util.Map;

import javax.baja.sys.*;
import javax.baja.status.*;

/**
 * BFaultAlgorithm is the super-class of all fault-detection
 * mechanisms defined by Niagara.  The default implementation
 * will never generate any toFault alarms.
  *
 * @author    Dan Giorgis
 * @creation  13 Nov 00
 * @version   $Revision: 21$ $Date: 2/14/06 2:21:36 PM EST$
 * @since     Baja 1.0
 */
public class BFaultAlgorithm
  extends BAlarmAlgorithm
{
  /*-
  class BFaultAlgorithm
  {
  }

 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.alarm.ext.BFaultAlgorithm(157196084)1.0$ @*/
/* Generated Sat Dec 17 21:33:33 EST 2011 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  @Override
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BFaultAlgorithm.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/


////////////////////////////////////////////////////////////////
//  Parent checking
////////////////////////////////////////////////////////////////

  /**
   * A BFaultAlgorithm's parent must be a BAlarmSourceExt
   */
  @Override
  public boolean isParentLegal(BComponent parent)
  {
    return parent instanceof BAlarmSourceExt;
  }


  @Override
  public boolean isGrandparentLegal(BComponent grandparent)
  {
    return true;
  }

////////////////////////////////////////////////////////////////
//  Fault transistion checking
////////////////////////////////////////////////////////////////

  /**
   *  Check for transitions to or from the fault state.
   *  Returns BAlarmState.fault on a to-fault transition,
   *  BAlarmState.normal on a to-normal transition and null
   *  if no change in state occured.
   */
  public BAlarmState checkFault(BStatusValue out)
  {
    return null;
  }

////////////////////////////////////////////////////////////////
//  Override Points
////////////////////////////////////////////////////////////////

  /**
   *  Check for a normal / fault alarm transition.  Return
   * new alarm state or null if no change.
   */
  public final BAlarmState checkAlarmState(BStatusValue out)
  {
    return null;
  }

  /**
   *  Write the key-value pairs defining alarm data for the
   *  alarm algorithm and state to the given Map.
   *
   * @param out The relevant control point status value
   * @param map The map.
   */
  @SuppressWarnings("rawtypes")
  public void writeAlarmData(BStatusValue out, Map map)
  {
  }

}