/*
 * Copyright 2000-2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.alarm;

import javax.baja.sys.*;

/**
 * RemoteAlarmRecipient iis a marker interface for AlarmRecipients that are remote
 * to the station that generates the alarm. <br>
 * Methods must be implemented as actions.
 *
 * @author    Blake M Puhak       
 * @creation  23 Aug 02
 * @version   $Revision: 3$ $Date: 3/30/05 11:35:59 AM EST$
 * @since     Baja 1.0
 */
public interface BIRemoteAlarmRecipient
  extends BInterface
{
  public void routeAlarm(BAlarmRecord alarm)
    throws Exception;
  
  public static final Type TYPE = Sys.loadType(BIRemoteAlarmRecipient.class);
  
}
