/**
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.alarm;

import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BISpace;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Common interface for all AlarmSpace implementations.
 *
 * @author Blake Puhak
 * @creation 11 June 2014
 * @since Niagara 4.0
 */
@NiagaraType
public interface BIAlarmSpace
  extends BISpace
{
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $javax.baja.alarm.BIAlarmSpace(2979906276)1.0$ @*/
/* Generated Mon Feb 20 14:03:49 EST 2017 by Slot-o-Matic (c) Tridium, Inc. 2012 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  Type TYPE = Sys.loadType(BIAlarmSpace.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Open a connection to the alarm space.  All interactions with an AlarmDb
   * are managed through a AlarmDbConnection.
   *
   * @param context context of the connection
   * @return Returns a connection to the alarm database.
   */
  AlarmSpaceConnection getConnection(Context context);
}