function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * Copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/* eslint-env browser */

/**
 * API Status: **Private**
 * @module nmodule/kitPx/rc/ux/ImageButton
 */
define(['baja!', 'bajaux/icon/iconUtils', 'bajaux/spandrel', 'nmodule/bajaui/rc/ux/Button', 'nmodule/webEditors/rc/util/htmlUtils', 'baja!gx:Image', 'css!nmodule/kitPx/rc/kitPx'], function (baja, iconUtils, spandrel, Button, htmlUtils) {
  'use strict';

  var escapeHtml = htmlUtils.escapeHtml;
  var NULL_IMAGE = baja.$("gx:Image");
  var HIDE_LABEL_CLASS = "-t-ImageButton-no-label";
  var HIDE_LABEL_ICON_CLASS = "-t-ImageButton-no-label-icon";

  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'ux-Button ux-ImageButton',
        textOverride: baja.Format.DEFAULT,
        disabled: NULL_IMAGE,
        normal: NULL_IMAGE,
        mouseOver: NULL_IMAGE,
        pressed: NULL_IMAGE
      }
    };
  };

  var isNullImage = function isNullImage(image) {
    return image.toString() === NULL_IMAGE.toString();
  };

  var getImageStyleString = function getImageStyleString(image) {
    if (isNullImage(image)) {
      return "";
    }

    var imageOrd = baja.Ord.make(image.valueOf());
    var url = escapeHtml(iconUtils.toUris(imageOrd)[0]);
    return "url(\"".concat(url, "\")");
  };
  /**
   * @class
   * @alias module:nmodule/kitPx/rc/ux/ImageButton
   * @extends module:nmodule/bajaui/rc/ux/Button
   */


  return /*#__PURE__*/function (_spandrel) {
    _inherits(ImageButton, _spandrel);

    var _super = _createSuper(ImageButton);

    function ImageButton(params) {
      _classCallCheck(this, ImageButton);

      return _super.call(this, {
        params: params,
        defaults: widgetDefaults()
      });
    }

    _createClass(ImageButton, [{
      key: "doInitialize",
      value: function doInitialize(dom) {
        this.$registerEventHandlers(dom);
        return Button.prototype.doInitialize.apply(this, arguments);
      }
    }, {
      key: "render",
      value: function render() {
        //TODO: NCCB-45981 (possibly remove after)
        return Button.prototype.render.apply(this, arguments);
      }
    }, {
      key: "$setImage",
      value: function $setImage(image) {
        this.jq().find("button > .-t-ImageButton-backgroundImage").css("background-image", getImageStyleString(image));
      }
    }, {
      key: "$registerEventHandlers",
      value: function $registerEventHandlers(dom) {
        var _this = this;

        var isPressed = false,
            isMouseOver = false;

        var updateDisplay = function updateDisplay() {
          if (!_this.isEnabled()) {
            return;
          }

          var normalImage = _this.properties().getValue("normal"),
              mouseOverImage = _this.properties().getValue("mouseOver"),
              pressedImage = _this.properties().getValue("pressed"),
              button = _this.jq().find("button");

          button.toggleClass(HIDE_LABEL_CLASS, true);

          if (isPressed && isMouseOver && !isNullImage(pressedImage)) {
            _this.$setImage(pressedImage);
          } else if (isMouseOver && !isNullImage(mouseOverImage)) {
            _this.$setImage(mouseOverImage);
          } else if (!isNullImage(normalImage)) {
            _this.$setImage(normalImage);
          } else {
            _this.$setImage(NULL_IMAGE);

            button.toggleClass(HIDE_LABEL_CLASS, false);
          }
        };

        dom.on('mousedown', function () {
          isPressed = true;
          isMouseOver = true;
          updateDisplay();
        });
        dom.on('mouseup', function () {
          isPressed = false;
          isMouseOver = true;
          updateDisplay();
        });
        dom.hover(function () {
          isMouseOver = true;
          updateDisplay();
        }, function () {
          isMouseOver = false;
          isPressed = false;
          updateDisplay();
        });
      }
    }]);

    return ImageButton;
  }(spandrel(function (value, _ref) {
    var properties = _ref.properties,
        renderSuper = _ref.renderSuper;
    return renderSuper().then(function (result) {
      var enabled = properties.enabled,
          disabled = properties.disabled,
          normal = properties.normal,
          pressed = properties.pressed,
          mouseOver = properties.mouseOver;
      var buttonClassList = result[0].kids[0].dom.classList;
      var backgroundImageDOM = document.createElement('div');
      backgroundImageDOM.classList.add("-t-ImageButton-backgroundImage");

      if (!enabled && !isNullImage(disabled)) {
        backgroundImageDOM.style.backgroundImage = getImageStyleString(disabled);
      } else if (!enabled && !isNullImage(normal)) {
        backgroundImageDOM.style.backgroundImage = getImageStyleString(normal);
      } else if (enabled && !isNullImage(normal)) {
        backgroundImageDOM.style.backgroundImage = getImageStyleString(normal);
        buttonClassList.add(HIDE_LABEL_CLASS);
      }

      result[0].kids[0].kids = {
        background: {
          dom: backgroundImageDOM
        },
        label: result[0].kids[0].kids.label
      };
      var isLabelIconVisible = isNullImage(normal) && isNullImage(mouseOver) && isNullImage(pressed);

      if (!isLabelIconVisible) {
        buttonClassList.add(HIDE_LABEL_ICON_CLASS);
      }

      return result;
    });
  }, {
    "extends": Button
  }));
});
